/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.IngredientRegistry;
import mezz.jei.Internal;
import mezz.jei.ItemBlacklist;
import mezz.jei.JeiHelpers;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.config.Config;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.util.IngredientListElement;
import mezz.jei.util.Java6Helper;
import mezz.jei.util.Log;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.SplashProgress;
import net.minecraftforge.fml.common.ProgressManager;

public class IngredientBaseListFactory {
    private IngredientBaseListFactory() {
    }

    public static ImmutableList<IIngredientListElement> create(boolean showProgressBar) {
        Log.info("Building item filter...", new Object[0]);
        long start_time = System.currentTimeMillis();
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        JeiHelpers jeiHelpers = Internal.getHelpers();
        IngredientChecker ingredientChecker = new IngredientChecker(jeiHelpers);
        LinkedList<IIngredientListElement> ingredientListElements = new LinkedList<IIngredientListElement>();
        for (Class ingredientClass : ingredientRegistry.getRegisteredIngredientClasses()) {
            IngredientBaseListFactory.addToBaseList(ingredientListElements, ingredientRegistry, ingredientChecker, ingredientClass, showProgressBar);
        }
        IngredientBaseListFactory.sortIngredientListElements(ingredientListElements);
        ImmutableList immutableElements = ImmutableList.copyOf(ingredientListElements);
        Log.info("Built    item filter in {} ms", System.currentTimeMillis() - start_time);
        return immutableElements;
    }

    private static <V> void addToBaseList(List<IIngredientListElement> baseList, IIngredientRegistry ingredientRegistry, IngredientChecker ingredientChecker, Class<V> ingredientClass, boolean showProgressBar) {
        IIngredientHelper<V> ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientClass);
        IIngredientRenderer<V> ingredientRenderer = ingredientRegistry.getIngredientRenderer(ingredientClass);
        List<V> ingredients = ingredientRegistry.getIngredients(ingredientClass);
        int ingredientCount = ingredients.size();
        if (ingredientCount <= 0) {
            return;
        }
        int steps = 100;
        ProgressManager.ProgressBar bar = null;
        if (showProgressBar) {
            bar = ProgressManager.push((String)("Adding " + ingredientClass.getSimpleName() + " ingredients."), (int)100);
            SplashProgress.pause();
        }
        int count = 0;
        for (V ingredient : ingredients) {
            IngredientListElement<V> ingredientListElement;
            if (ingredient != null && !ingredientChecker.isIngredientHidden(ingredient, ingredientHelper) && (ingredientListElement = IngredientListElement.create(ingredient, ingredientHelper, ingredientRenderer)) != null) {
                baseList.add(ingredientListElement);
            }
            count += 100;
            while (bar != null && count > bar.getStep() * ingredientCount) {
                SplashProgress.resume();
                bar.step("" + count / ingredientCount + "%");
                SplashProgress.pause();
            }
        }
        if (bar != null) {
            SplashProgress.resume();
            ProgressManager.pop(bar);
        }
    }

    private static void sortIngredientListElements(List<IIngredientListElement> ingredientListElements) {
        int index = 0;
        final HashMap<String, Integer> itemAddedOrder = new HashMap<String, Integer>();
        for (IIngredientListElement ingredientListElement : ingredientListElements) {
            String uid = IngredientBaseListFactory.getWildcardUid(ingredientListElement);
            if (itemAddedOrder.containsKey(uid)) continue;
            itemAddedOrder.put(uid, index);
            ++index;
        }
        Collections.sort(ingredientListElements, new Comparator<IIngredientListElement>(){

            @Override
            public int compare(IIngredientListElement o1, IIngredientListElement o2) {
                String modName2;
                String modName1 = IngredientBaseListFactory.getModName(o1);
                if (modName1.equals(modName2 = IngredientBaseListFactory.getModName(o2))) {
                    boolean isItemStack1 = o1.getIngredient() instanceof ItemStack;
                    boolean isItemStack2 = o2.getIngredient() instanceof ItemStack;
                    if (isItemStack1 && !isItemStack2) {
                        return -1;
                    }
                    if (!isItemStack1 && isItemStack2) {
                        return 1;
                    }
                    String uid1 = IngredientBaseListFactory.getWildcardUid(o1);
                    String uid2 = IngredientBaseListFactory.getWildcardUid(o2);
                    int orderIndex1 = (Integer)itemAddedOrder.get(uid1);
                    int orderIndex2 = (Integer)itemAddedOrder.get(uid2);
                    return Java6Helper.compare(orderIndex1, orderIndex2);
                }
                if (modName1.equals("Minecraft")) {
                    return -1;
                }
                if (modName2.equals("Minecraft")) {
                    return 1;
                }
                return modName1.compareTo(modName2);
            }
        });
    }

    private static <V> String getModName(IIngredientListElement<V> ingredientListElement) {
        V ingredient = ingredientListElement.getIngredient();
        IIngredientHelper<V> ingredientHelper = ingredientListElement.getIngredientHelper();
        String modId = ingredientHelper.getModId(ingredient);
        return Internal.getModIdUtil().getModNameForModId(modId);
    }

    private static <V> String getWildcardUid(IIngredientListElement<V> ingredientListElement) {
        V ingredient = ingredientListElement.getIngredient();
        IIngredientHelper<V> ingredientHelper = ingredientListElement.getIngredientHelper();
        return ingredientHelper.getWildcardId(ingredient);
    }

    private static class IngredientChecker {
        private final ItemBlacklist itemBlacklist;

        public IngredientChecker(JeiHelpers jeiHelpers) {
            this.itemBlacklist = jeiHelpers.getItemBlacklist();
        }

        public <V> boolean isIngredientHidden(V ingredient, IIngredientHelper<V> ingredientHelper) {
            try {
                if (ingredient instanceof ItemStack && this.itemBlacklist.isItemBlacklistedByApi((ItemStack)ingredient)) {
                    return true;
                }
                if (!Config.isEditModeEnabled() && Config.isIngredientOnConfigBlacklist(ingredient, ingredientHelper)) {
                    return true;
                }
            }
            catch (RuntimeException e) {
                String ingredientInfo = ingredientHelper.getErrorInfo(ingredient);
                Log.error("Could not check blacklist for ingredient {}", ingredientInfo, e);
                return true;
            }
            return false;
        }
    }
}

