/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mezz.jei.util.Log;
import mezz.jei.util.StackHelper;
import net.minecraft.item.ItemStack;

public class UniqueItemStackListBuilder {
    private final StackHelper stackHelper;
    private final List<ItemStack> ingredients = new ArrayList<ItemStack>();
    private final Set<String> ingredientUids = new HashSet<String>();

    public UniqueItemStackListBuilder(StackHelper stackHelper) {
        this.stackHelper = stackHelper;
    }

    public void add(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return;
        }
        try {
            String uid = this.stackHelper.getUniqueIdentifierForStack(itemStack);
            if (!this.ingredientUids.contains(uid)) {
                this.ingredientUids.add(uid);
                this.ingredients.add(itemStack);
            }
        }
        catch (RuntimeException e) {
            Log.error("Failed to get unique identifier for stack.", e);
        }
        catch (LinkageError e) {
            Log.error("Failed to get unique identifier for stack.", e);
        }
    }

    public List<ItemStack> build() {
        return this.ingredients;
    }
}

