/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Java6Helper;
import mezz.jei.util.Log;
import mezz.jei.util.UniqueItemStackListBuilder;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class StackHelper
implements IStackHelper {
    private final ISubtypeRegistry subtypeRegistry;
    private final Map<UidMode, Map<ItemStack, String>> uidCache = new EnumMap<UidMode, Map<ItemStack, String>>(UidMode.class);
    private boolean uidCacheEnabled = true;

    public StackHelper(ISubtypeRegistry subtypeRegistry) {
        this.subtypeRegistry = subtypeRegistry;
        for (UidMode mode : UidMode.values()) {
            this.uidCache.put(mode, new IdentityHashMap());
        }
    }

    public void enableUidCache() {
        this.uidCacheEnabled = true;
    }

    public void disableUidCache() {
        for (UidMode mode : UidMode.values()) {
            this.uidCache.get((Object)mode).clear();
        }
        this.uidCacheEnabled = false;
    }

    @Nullable
    public String getOreDictEquivalent(Collection<ItemStack> itemStacks) {
        if (itemStacks.size() < 2) {
            return null;
        }
        ItemStack firstStack = itemStacks.iterator().next();
        if (firstStack != null) {
            for (int oreId : OreDictionary.getOreIDs((ItemStack)firstStack)) {
                String oreName = OreDictionary.getOreName((int)oreId);
                List<ItemStack> ores = OreDictionary.getOres((String)oreName);
                if (!this.containsSameStacks(itemStacks, (Collection<ItemStack>)(ores = this.getAllSubtypes(ores)))) continue;
                return oreName;
            }
        }
        return null;
    }

    public MatchingItemsResult getMatchingItems(Map<Integer, ItemStack> availableItemStacks, Map<Integer, ? extends IGuiIngredient<ItemStack>> ingredientsMap) {
        MatchingItemsResult matchingItemResult = new MatchingItemsResult();
        int recipeSlotNumber = -1;
        TreeSet<Integer> keys = new TreeSet<Integer>(ingredientsMap.keySet());
        for (Integer key : keys) {
            IGuiIngredient<ItemStack> ingredient = ingredientsMap.get(key);
            if (!ingredient.isInput()) continue;
            ++recipeSlotNumber;
            List<ItemStack> requiredStacks = ingredient.getAllIngredients();
            if (requiredStacks.isEmpty()) continue;
            Integer matching = this.containsAnyStackIndexed(availableItemStacks, requiredStacks);
            if (matching == null) {
                matchingItemResult.missingItems.add(key);
                continue;
            }
            ItemStack matchingStack = availableItemStacks.get(matching);
            matchingStack.func_190918_g(1);
            if (matchingStack.func_190916_E() == 0) {
                availableItemStacks.remove(matching);
            }
            matchingItemResult.matchingItems.put(recipeSlotNumber, matching);
        }
        return matchingItemResult;
    }

    public boolean containsSameStacks(Collection<ItemStack> stacks, Collection<ItemStack> contains) {
        return this.containsSameStacks(new MatchingIterable(stacks), new MatchingIterable(contains));
    }

    public <R> boolean containsSameStacks(Iterable<ItemStackMatchable<R>> stacks, Iterable<ItemStackMatchable<R>> contains) {
        for (ItemStackMatchable<R> stack : contains) {
            if (this.containsStack(stacks, stack) != null) continue;
            return false;
        }
        for (ItemStackMatchable<R> stack : stacks) {
            if (this.containsStack(contains, stack) != null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public Integer containsAnyStackIndexed(@Nullable Map<Integer, ItemStack> stacks, @Nullable Iterable<ItemStack> contains) {
        MatchingIndexed matchingStacks = new MatchingIndexed(stacks);
        MatchingIterable matchingContains = new MatchingIterable(contains);
        return this.containsStackMatchable(matchingStacks, matchingContains);
    }

    @Nullable
    public ItemStack containsStack(@Nullable Iterable<ItemStack> stacks, @Nullable ItemStack contains) {
        List<ItemStack> containsList = contains == null ? null : Collections.singletonList(contains);
        return this.containsAnyStack(stacks, containsList);
    }

    @Nullable
    public ItemStack containsAnyStack(@Nullable Iterable<ItemStack> stacks, @Nullable Iterable<ItemStack> contains) {
        MatchingIterable matchingStacks = new MatchingIterable(stacks);
        MatchingIterable matchingContains = new MatchingIterable(contains);
        return this.containsStackMatchable(matchingStacks, matchingContains);
    }

    @Nullable
    public <R, T> R containsStackMatchable(Iterable<ItemStackMatchable<R>> stacks, Iterable<ItemStackMatchable<T>> contains) {
        for (ItemStackMatchable<T> containStack : contains) {
            R matchingStack = this.containsStack(stacks, containStack);
            if (matchingStack == null) continue;
            return matchingStack;
        }
        return null;
    }

    @Nullable
    public <R> R containsStack(Iterable<ItemStackMatchable<R>> stacks, ItemStackMatchable<?> contains) {
        for (ItemStackMatchable<R> stack : stacks) {
            if (!this.isEquivalent(contains.getStack(), stack.getStack())) continue;
            return stack.getResult();
        }
        return null;
    }

    public boolean isEquivalent(@Nullable ItemStack lhs, @Nullable ItemStack rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.func_77973_b() != rhs.func_77973_b()) {
            return false;
        }
        if (lhs.func_77960_j() != Short.MAX_VALUE && lhs.func_77960_j() != rhs.func_77960_j()) {
            return false;
        }
        if (lhs.func_77981_g()) {
            String keyLhs = this.getUniqueIdentifierForStack(lhs, UidMode.NORMAL);
            String keyRhs = this.getUniqueIdentifierForStack(rhs, UidMode.NORMAL);
            return Java6Helper.equals(keyLhs, keyRhs);
        }
        return true;
    }

    @Override
    public List<ItemStack> getSubtypes(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("Null itemStack");
        }
        if (itemStack.func_190926_b()) {
            return Collections.emptyList();
        }
        if (itemStack.func_77952_i() != Short.MAX_VALUE) {
            return Collections.singletonList(itemStack);
        }
        return this.getSubtypes(itemStack.func_77973_b(), itemStack.func_190916_E());
    }

    public List<ItemStack> getSubtypes(Item item, int stackSize) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (CreativeTabs itemTab : item.getCreativeTabs()) {
            NonNullList subItems = NonNullList.func_191196_a();
            try {
                item.func_150895_a(item, itemTab, subItems);
            }
            catch (RuntimeException e) {
                Log.warning("Caught a crash while getting sub-items of {}", item, e);
            }
            catch (LinkageError e) {
                Log.warning("Caught a crash while getting sub-items of {}", item, e);
            }
            for (ItemStack subItem : subItems) {
                if (subItem == null) {
                    Log.warning("Found a null subItem of {}", item);
                    continue;
                }
                if (subItem.func_190926_b()) {
                    Log.warning("Found a subItem of {} with an invalid item", item);
                    continue;
                }
                if (subItem.func_190916_E() != stackSize) {
                    ItemStack subItemCopy = subItem.func_77946_l();
                    subItemCopy.func_190920_e(stackSize);
                    itemStacks.add(subItemCopy);
                    continue;
                }
                itemStacks.add(subItem);
            }
        }
        return itemStacks;
    }

    @Override
    public List<ItemStack> getAllSubtypes(@Nullable Iterable stacks) {
        if (stacks == null) {
            Log.error("Null stacks", new NullPointerException());
            return Collections.emptyList();
        }
        ArrayList<ItemStack> allSubtypes = new ArrayList<ItemStack>();
        this.getAllSubtypes(allSubtypes, stacks);
        if (StackHelper.isAllNulls(allSubtypes)) {
            return Collections.emptyList();
        }
        return allSubtypes;
    }

    private static boolean isAllNulls(Iterable<?> iterable) {
        for (Object element : iterable) {
            if (element == null) continue;
            return false;
        }
        return true;
    }

    private void getAllSubtypes(List<ItemStack> subtypesList, Iterable stacks) {
        for (Object obj : stacks) {
            if (obj instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)obj;
                List<ItemStack> subtypes = this.getSubtypes(itemStack);
                subtypesList.addAll(subtypes);
                continue;
            }
            if (obj instanceof Iterable) {
                this.getAllSubtypes(subtypesList, (Iterable)obj);
                continue;
            }
            if (obj != null) {
                Log.error("Unknown object found: {}", obj);
                continue;
            }
            subtypesList.add(null);
        }
    }

    @Override
    public List<List<ItemStack>> expandRecipeItemStackInputs(@Nullable List inputs) {
        if (inputs == null) {
            return Collections.emptyList();
        }
        ArrayList<List<ItemStack>> expandedInputs = new ArrayList<List<ItemStack>>();
        for (Object input : inputs) {
            List<ItemStack> expandedInput = this.toItemStackList(input);
            expandedInputs.add(expandedInput);
        }
        return expandedInputs;
    }

    @Override
    public List<ItemStack> toItemStackList(@Nullable Object stacks) {
        if (stacks == null) {
            return Collections.emptyList();
        }
        UniqueItemStackListBuilder itemStackListBuilder = new UniqueItemStackListBuilder(this);
        this.toItemStackList(itemStackListBuilder, stacks);
        return itemStackListBuilder.build();
    }

    private void toItemStackList(UniqueItemStackListBuilder itemStackListBuilder, @Nullable Object input) {
        if (input instanceof ItemStack) {
            ItemStack stack = (ItemStack)input;
            if (stack.func_77960_j() == Short.MAX_VALUE) {
                List<ItemStack> subtypes = this.getSubtypes(stack);
                for (ItemStack subtype : subtypes) {
                    itemStackListBuilder.add(subtype);
                }
            } else {
                itemStackListBuilder.add(stack);
            }
        } else if (input instanceof String) {
            List stacks = OreDictionary.getOres((String)((String)input));
            for (ItemStack stack : stacks) {
                itemStackListBuilder.add(stack);
            }
        } else if (input instanceof Iterable) {
            for (Object obj : (Iterable)input) {
                this.toItemStackList(itemStackListBuilder, obj);
            }
        } else if (input != null) {
            Log.error("Unknown object found: {}", input);
        }
    }

    public String getUniqueIdentifierForStack(ItemStack stack) {
        return this.getUniqueIdentifierForStack(stack, UidMode.NORMAL);
    }

    public String getUniqueIdentifierForStack(ItemStack stack, UidMode mode) {
        String result;
        if (this.uidCacheEnabled && (result = this.uidCache.get((Object)mode).get(stack)) != null) {
            return result;
        }
        Item item = stack.func_77973_b();
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("Invalid Itemstack");
        }
        ResourceLocation itemName = item.getRegistryName();
        if (itemName == null) {
            String stackInfo = ErrorUtil.getItemStackInfo(stack);
            throw new NullPointerException("Item has no registry name: " + stackInfo);
        }
        StringBuilder itemKey = new StringBuilder(itemName.toString());
        if (mode != UidMode.WILDCARD) {
            String subtypeInfo = this.subtypeRegistry.getSubtypeInfo(stack);
            if (subtypeInfo != null) {
                itemKey.append(':').append(subtypeInfo);
            } else {
                int metadata = stack.func_77960_j();
                if (mode == UidMode.FULL) {
                    NBTTagCompound forgeCaps;
                    itemKey.append(':').append(metadata);
                    NBTTagCompound serializedNbt = stack.serializeNBT();
                    NBTTagCompound nbtTagCompound = serializedNbt.func_74775_l("tag").func_74737_b();
                    if (serializedNbt.func_74764_b("ForgeCaps") && !(forgeCaps = serializedNbt.func_74775_l("ForgeCaps")).func_82582_d()) {
                        nbtTagCompound.func_74782_a("ForgeCaps", (NBTBase)forgeCaps);
                    }
                    if (!nbtTagCompound.func_82582_d()) {
                        itemKey.append(':').append(nbtTagCompound);
                    }
                } else if (metadata != Short.MAX_VALUE && stack.func_77981_g()) {
                    itemKey.append(':').append(metadata);
                }
            }
        }
        String result2 = itemKey.toString();
        if (this.uidCacheEnabled) {
            this.uidCache.get((Object)mode).put(stack, result2);
        }
        return result2;
    }

    private static class MatchingIndexed
    implements Iterable<ItemStackMatchable<Integer>> {
        @Nonnull
        private final Map<Integer, ItemStack> map;

        public MatchingIndexed(@Nullable Map<Integer, ItemStack> map) {
            this.map = map == null ? Collections.emptyMap() : map;
        }

        @Override
        @Nonnull
        public Iterator<ItemStackMatchable<Integer>> iterator() {
            return new DelegateIterator<Map.Entry<Integer, ItemStack>, ItemStackMatchable<Integer>>(this.map.entrySet().iterator()){

                @Override
                public ItemStackMatchable<Integer> next() {
                    final Map.Entry entry = (Map.Entry)this.delegate.next();
                    return new ItemStackMatchable<Integer>(){

                        @Override
                        @Nonnull
                        public ItemStack getStack() {
                            return (ItemStack)entry.getValue();
                        }

                        @Override
                        @Nonnull
                        public Integer getResult() {
                            return (Integer)entry.getKey();
                        }
                    };
                }
            };
        }
    }

    private static class MatchingIterable
    implements Iterable<ItemStackMatchable<ItemStack>> {
        @Nonnull
        private final Iterable<ItemStack> list;

        public MatchingIterable(@Nullable Iterable<ItemStack> list) {
            this.list = list == null ? Collections.emptyList() : list;
        }

        @Override
        @Nonnull
        public Iterator<ItemStackMatchable<ItemStack>> iterator() {
            Iterator<ItemStack> stacks = this.list.iterator();
            return new DelegateIterator<ItemStack, ItemStackMatchable<ItemStack>>(stacks){

                @Override
                public ItemStackMatchable<ItemStack> next() {
                    final ItemStack stack = (ItemStack)this.delegate.next();
                    return new ItemStackMatchable<ItemStack>(){

                        @Override
                        @Nullable
                        public ItemStack getStack() {
                            return stack;
                        }

                        @Override
                        @Nullable
                        public ItemStack getResult() {
                            return stack;
                        }
                    };
                }
            };
        }
    }

    private static abstract class DelegateIterator<T, R>
    implements Iterator<R> {
        @Nonnull
        protected final Iterator<T> delegate;

        public DelegateIterator(Iterator<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }

    private static interface ItemStackMatchable<R> {
        @Nullable
        public ItemStack getStack();

        @Nullable
        public R getResult();
    }

    public static class MatchingItemsResult {
        @Nonnull
        public final Map<Integer, Integer> matchingItems = new HashMap<Integer, Integer>();
        @Nonnull
        public final List<Integer> missingItems = new ArrayList<Integer>();
    }

    public static enum UidMode {
        NORMAL,
        WILDCARD,
        FULL;

    }
}

