/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import mezz.jei.JustEnoughItems;
import mezz.jei.config.SessionData;
import mezz.jei.network.packets.PacketGiveItemStack;
import mezz.jei.util.CommandUtil;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;

public class Commands {
    public static void giveFullStack(ItemStack itemstack) {
        Commands.giveStack(itemstack, itemstack.func_77976_d());
    }

    public static void giveOneFromStack(ItemStack itemstack) {
        Commands.giveStack(itemstack, 1);
    }

    public static void giveStack(ItemStack itemStack, int amount) {
        if (SessionData.isJeiOnServer()) {
            ItemStack sendStack = itemStack.func_77946_l();
            sendStack.func_190920_e(amount);
            PacketGiveItemStack packet = new PacketGiveItemStack(sendStack);
            JustEnoughItems.getProxy().sendPacketToServer(packet);
        } else {
            Commands.giveStackVanilla(itemStack, amount);
        }
    }

    private static void giveStackVanilla(ItemStack itemStack, int amount) {
        if (itemStack.func_190926_b()) {
            String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
            Log.error("Invalid itemStack: " + stackInfo, new IllegalArgumentException());
            return;
        }
        Item item = itemStack.func_77973_b();
        ResourceLocation itemResourceLocation = item.getRegistryName();
        if (itemResourceLocation == null) {
            String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
            Log.error("item.getRegistryName() returned null for: " + stackInfo, new NullPointerException());
            return;
        }
        EntityPlayerSP sender = Minecraft.func_71410_x().field_71439_g;
        Object[] commandParameters = CommandUtil.getGiveCommandParameters((EntityPlayer)sender, itemStack, amount);
        String fullCommand = "/give " + StringUtils.join((Object[])commandParameters, (String)" ");
        Commands.sendChatMessage(sender, fullCommand);
    }

    private static void sendChatMessage(EntityPlayerSP sender, String chatMessage) {
        if (chatMessage.length() <= 256) {
            sender.func_71165_d(chatMessage);
        } else {
            TextComponentTranslation errorMessage = new TextComponentTranslation("jei.chat.error.command.too.long", new Object[0]);
            errorMessage.func_150256_b().func_150238_a(TextFormatting.RED);
            sender.func_146105_b((ITextComponent)errorMessage, false);
            TextComponentString chatMessageComponent = new TextComponentString(chatMessage);
            chatMessageComponent.func_150256_b().func_150238_a(TextFormatting.RED);
            sender.func_146105_b((ITextComponent)chatMessageComponent, false);
        }
    }
}

