/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.crafting;

import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.plugins.vanilla.crafting.ShapedRecipesWrapper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;

public class ShapedRecipesHandler
implements IRecipeHandler<ShapedRecipes> {
    @Override
    public Class<ShapedRecipes> getRecipeClass() {
        return ShapedRecipes.class;
    }

    @Override
    public String getRecipeCategoryUid(ShapedRecipes recipe) {
        return "minecraft.crafting";
    }

    @Override
    public IRecipeWrapper getRecipeWrapper(ShapedRecipes recipe) {
        return new ShapedRecipesWrapper(recipe);
    }

    @Override
    public boolean isRecipeValid(ShapedRecipes recipe) {
        String recipeInfo;
        if (recipe.func_77571_b() == null) {
            String recipeInfo2 = ErrorUtil.getInfoFromBrokenRecipe(recipe, this);
            Log.error("Recipe has no outputs. {}", recipeInfo2);
            return false;
        }
        int inputCount = 0;
        for (ItemStack input : recipe.field_77574_d) {
            if (input == null) continue;
            ++inputCount;
        }
        if (inputCount > 9) {
            recipeInfo = ErrorUtil.getInfoFromBrokenRecipe(recipe, this);
            Log.error("Recipe has too many inputs. {}", recipeInfo);
            return false;
        }
        if (inputCount == 0) {
            recipeInfo = ErrorUtil.getInfoFromBrokenRecipe(recipe, this);
            Log.error("Recipe has no inputs. {}", recipeInfo);
            return false;
        }
        return true;
    }
}

