/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.crafting;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.config.Constants;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.HoverChecker;

public abstract class AbstractShapelessRecipeWrapper
extends BlankRecipeWrapper
implements ICraftingRecipeWrapper {
    private static final double shapelessIconScale = 0.5;
    private final IDrawable shapelessIcon;
    private final HoverChecker shapelessIconHoverChecker;

    public AbstractShapelessRecipeWrapper(IGuiHelper guiHelper) {
        ResourceLocation shapelessIconLocation = new ResourceLocation(Constants.RESOURCE_DOMAIN, "textures/gui/recipe_background.png");
        this.shapelessIcon = guiHelper.createDrawable(shapelessIconLocation, 196, 0, 19, 15);
        int iconBottom = (int)((double)this.shapelessIcon.getHeight() * 0.5);
        int iconLeft = 116 - (int)((double)this.shapelessIcon.getWidth() * 0.5);
        int iconRight = iconLeft + (int)((double)this.shapelessIcon.getWidth() * 0.5);
        this.shapelessIconHoverChecker = new HoverChecker(0, iconBottom, iconLeft, iconRight, 0);
    }

    @Override
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        if (this.hasMultipleIngredients()) {
            int shapelessIconX = recipeWidth - (int)((double)this.shapelessIcon.getWidth() * 0.5);
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.shapelessIcon.draw(minecraft, (int)((double)shapelessIconX / 0.5), 0);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    @Nullable
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (this.hasMultipleIngredients() && this.shapelessIconHoverChecker.checkHover(mouseX, mouseY)) {
            return Collections.singletonList(Translator.translateToLocal("jei.tooltip.shapeless.recipe"));
        }
        return super.getTooltipStrings(mouseX, mouseY);
    }

    protected abstract boolean hasMultipleIngredients();
}

