/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.IRecipesGui;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.GuiHelper;
import mezz.jei.gui.GuiProperties;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.IRecipeLogicStateListener;
import mezz.jei.gui.recipes.RecipeCategoryCraftingItems;
import mezz.jei.gui.recipes.RecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeGuiTabs;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.gui.recipes.RecipeTransferButton;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.input.InputHandler;
import mezz.jei.transfer.RecipeTransferUtil;
import mezz.jei.util.Log;
import mezz.jei.util.StringUtil;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.HoverChecker;
import org.lwjgl.input.Mouse;

public class RecipesGui
extends GuiScreen
implements IRecipesGui,
IShowsRecipeFocuses,
IRecipeLogicStateListener {
    private static final int borderPadding = 6;
    private static final int innerPadding = 5;
    private static final int textPadding = 5;
    private static final int buttonWidth = 13;
    private static final int buttonHeight = 12;
    private int titleHeight;
    private int headerHeight;
    private final IRecipeGuiLogic logic;
    private final List<RecipeLayout> recipeLayouts = new ArrayList<RecipeLayout>();
    private String pageString = "1/1";
    private String title = "";
    private ResourceLocation backgroundTexture = Internal.getHelpers().getGuiHelper().getRecipeBackgroundResource();
    private final RecipeCategoryCraftingItems recipeCategoryCraftingItems;
    private final RecipeGuiTabs recipeGuiTabs;
    private HoverChecker titleHoverChecker = new HoverChecker(0, 0, 0, 0, 0);
    private final GuiButton nextRecipeCategory;
    private final GuiButton previousRecipeCategory;
    private final GuiButton nextPage;
    private final GuiButton previousPage;
    @Nullable
    private GuiScreen parentScreen;
    private int xSize;
    private int ySize;
    private int guiLeft;
    private int guiTop;
    private boolean init = false;

    public RecipesGui(IRecipeRegistry recipeRegistry) {
        this.logic = new RecipeGuiLogic(recipeRegistry, this);
        this.recipeCategoryCraftingItems = new RecipeCategoryCraftingItems();
        this.recipeGuiTabs = new RecipeGuiTabs(this.logic);
        this.field_146297_k = Minecraft.func_71410_x();
        this.nextRecipeCategory = new GuiButtonExt(2, 0, 0, 13, 12, ">");
        this.previousRecipeCategory = new GuiButtonExt(3, 0, 0, 13, 12, "<");
        this.nextPage = new GuiButtonExt(4, 0, 0, 13, 12, ">");
        this.previousPage = new GuiButtonExt(5, 0, 0, 13, 12, "<");
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiTop() {
        return this.guiTop;
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.xSize = 196;
        GuiHelper guiHelper = Internal.getHelpers().getGuiHelper();
        if (this.field_146295_m > 300) {
            this.ySize = 256;
            this.backgroundTexture = guiHelper.getRecipeBackgroundTallResource();
        } else {
            this.ySize = 166;
            this.backgroundTexture = guiHelper.getRecipeBackgroundResource();
        }
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2 + 8;
        this.titleHeight = this.field_146289_q.field_78288_b + 6;
        this.headerHeight = this.titleHeight + this.field_146289_q.field_78288_b + 5;
        int rightButtonX = this.guiLeft + this.xSize - 6 - 13;
        int leftButtonX = this.guiLeft + 6;
        int recipeClassButtonTop = this.guiTop + this.titleHeight - 12 + 1;
        this.nextRecipeCategory.field_146128_h = rightButtonX;
        this.nextRecipeCategory.field_146129_i = recipeClassButtonTop;
        this.previousRecipeCategory.field_146128_h = leftButtonX;
        this.previousRecipeCategory.field_146129_i = recipeClassButtonTop;
        int pageButtonTop = this.guiTop + this.titleHeight + 3;
        this.nextPage.field_146128_h = rightButtonX;
        this.nextPage.field_146129_i = pageButtonTop;
        this.previousPage.field_146128_h = leftButtonX;
        this.previousPage.field_146129_i = pageButtonTop;
        this.addButtons();
        this.init = true;
        this.updateLayout();
    }

    private void addButtons() {
        this.field_146292_n.add(this.nextRecipeCategory);
        this.field_146292_n.add(this.previousRecipeCategory);
        this.field_146292_n.add(this.nextPage);
        this.field_146292_n.add(this.previousPage);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.backgroundTexture);
        this.field_73735_i = 0.0f;
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        GlStateManager.func_179084_k();
        RecipesGui.func_73734_a((int)(this.guiLeft + 6 + 13), (int)(this.guiTop + 6 - 2), (int)(this.guiLeft + this.xSize - 6 - 13), (int)(this.guiTop + 6 + 10), (int)0x30000000);
        RecipesGui.func_73734_a((int)(this.guiLeft + 6 + 13), (int)(this.guiTop + this.titleHeight + 5 - 2), (int)(this.guiLeft + this.xSize - 6 - 13), (int)(this.guiTop + this.titleHeight + 5 + 10), (int)0x30000000);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        StringUtil.drawCenteredString(this.field_146289_q, this.title, this.xSize, this.guiLeft, this.guiTop + 6, Color.WHITE.getRGB(), true);
        StringUtil.drawCenteredString(this.field_146289_q, this.pageString, this.xSize, this.guiLeft, this.guiTop + this.titleHeight + 5, Color.WHITE.getRGB(), true);
        this.nextRecipeCategory.func_146112_a(this.field_146297_k, mouseX, mouseY);
        this.previousRecipeCategory.func_146112_a(this.field_146297_k, mouseX, mouseY);
        this.nextPage.func_146112_a(this.field_146297_k, mouseX, mouseY);
        this.previousPage.func_146112_a(this.field_146297_k, mouseX, mouseY);
        RecipeLayout hovered = null;
        for (RecipeLayout recipeLayout : this.recipeLayouts) {
            if (recipeLayout.isMouseOver(mouseX, mouseY)) {
                hovered = recipeLayout;
                continue;
            }
            recipeLayout.draw(this.field_146297_k, mouseX, mouseY);
        }
        GuiIngredient<ItemStack> hoveredItemStack = this.recipeCategoryCraftingItems.draw(this.field_146297_k, mouseX, mouseY);
        this.recipeGuiTabs.draw(this.field_146297_k, mouseX, mouseY);
        if (hovered != null) {
            hovered.draw(this.field_146297_k, mouseX, mouseY);
        }
        if (hoveredItemStack != null) {
            hoveredItemStack.drawHovered(this.field_146297_k, 0, 0, mouseX, mouseY);
        }
        if (this.titleHoverChecker.checkHover(mouseX, mouseY) && !this.logic.hasAllCategories()) {
            String showAllRecipesString = Translator.translateToLocal("jei.tooltip.show.all.recipes");
            TooltipRenderer.drawHoveringText(this.field_146297_k, showAllRecipesString, mouseX, mouseY);
        }
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.field_146297_k.field_71462_r == this && mouseX >= this.guiLeft && mouseY >= this.guiTop && mouseX < this.guiLeft + this.xSize && mouseY < this.guiTop + this.ySize;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(int mouseX, int mouseY) {
        if (this.isOpen()) {
            IClickedIngredient<?> clicked = this.recipeCategoryCraftingItems.getIngredientUnderMouse(mouseX, mouseY);
            if (clicked != null) {
                return clicked;
            }
            if (this.isMouseOver(mouseX, mouseY)) {
                for (RecipeLayout recipeLayouts : this.recipeLayouts) {
                    Object clicked2 = recipeLayouts.getIngredientUnderMouse(mouseX, mouseY);
                    if (clicked2 == null) continue;
                    return new ClickedIngredient<Object>(clicked2);
                }
            }
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return true;
    }

    public void func_146274_d() throws IOException {
        int y;
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        if (this.isMouseOver(x, y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1)) {
            int scrollDelta = Mouse.getEventDWheel();
            if (scrollDelta < 0) {
                this.logic.nextPage();
                return;
            }
            if (scrollDelta > 0) {
                this.logic.previousPage();
                return;
            }
        }
        super.func_146274_d();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (this.titleHoverChecker.checkHover(mouseX, mouseY)) {
                if (this.logic.setCategoryFocus()) {
                    return;
                }
            } else {
                for (RecipeLayout recipeLayout : this.recipeLayouts) {
                    if (!recipeLayout.handleClick(this.field_146297_k, mouseX, mouseY, mouseButton)) continue;
                    return;
                }
            }
        }
        if (this.recipeGuiTabs.isMouseOver(mouseX, mouseY) && this.recipeGuiTabs.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (InputHandler.isInventoryCloseKey(keyCode) || InputHandler.isInventoryToggleKey(keyCode)) {
            this.close();
        } else if (KeyBindings.recipeBack.isActiveAndMatches(keyCode)) {
            this.back();
        }
    }

    public boolean isOpen() {
        return this.field_146297_k.field_71462_r == this;
    }

    private void open() {
        if (!this.isOpen()) {
            this.parentScreen = this.field_146297_k.field_71462_r;
        }
        this.field_146297_k.func_147108_a((GuiScreen)this);
    }

    public void close() {
        if (this.isOpen()) {
            if (this.parentScreen != null) {
                this.field_146297_k.func_147108_a(this.parentScreen);
                this.parentScreen = null;
            } else {
                this.field_146297_k.field_71439_g.func_71053_j();
            }
            this.logic.clearHistory();
        }
    }

    @Override
    public <V> void show(@Nullable IFocus<V> focus) {
        if (focus == null) {
            Log.error("Null focus", new NullPointerException());
            return;
        }
        if (this.logic.setFocus(focus)) {
            this.open();
        }
    }

    @Override
    public void showCategories(@Nullable List<String> recipeCategoryUids) {
        if (recipeCategoryUids == null) {
            Log.error("Null recipeCategoryUids", new NullPointerException());
            return;
        }
        if (recipeCategoryUids.isEmpty()) {
            Log.error("Empty recipeCategoryUids", new IllegalArgumentException());
            return;
        }
        if (this.logic.setCategoryFocus(recipeCategoryUids)) {
            this.open();
        }
    }

    public void back() {
        this.logic.back();
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton.field_146127_k == this.nextPage.field_146127_k) {
            this.logic.nextPage();
        } else if (guibutton.field_146127_k == this.previousPage.field_146127_k) {
            this.logic.previousPage();
        } else if (guibutton.field_146127_k == this.nextRecipeCategory.field_146127_k) {
            this.logic.nextRecipeCategory();
        } else if (guibutton.field_146127_k == this.previousRecipeCategory.field_146127_k) {
            this.logic.previousRecipeCategory();
        } else if (guibutton.field_146127_k >= 100) {
            int recipeIndex = guibutton.field_146127_k - 100;
            RecipeLayout recipeLayout = this.recipeLayouts.get(recipeIndex);
            boolean maxTransfer = GuiScreen.func_146272_n();
            Container container = this.getParentContainer();
            if (container != null && RecipeTransferUtil.transferRecipe(container, recipeLayout, (EntityPlayer)this.field_146297_k.field_71439_g, maxTransfer)) {
                this.close();
            }
        }
    }

    private void updateLayout() {
        if (!this.init) {
            return;
        }
        IRecipeCategory recipeCategory = this.logic.getSelectedRecipeCategory();
        IDrawable recipeBackground = recipeCategory.getBackground();
        int recipesPerPage = Math.max(1, (this.ySize - this.headerHeight) / (recipeBackground.getHeight() + 5));
        int recipeXOffset = this.guiLeft + (this.xSize - recipeBackground.getWidth()) / 2;
        int recipeSpacing = (this.ySize - this.headerHeight - recipesPerPage * recipeBackground.getHeight()) / (recipesPerPage + 1);
        this.logic.setRecipesPerPage(recipesPerPage);
        this.title = recipeCategory.getTitle();
        int titleWidth = this.field_146289_q.func_78256_a(this.title);
        int titleX = this.guiLeft + (this.xSize - titleWidth) / 2;
        int titleY = this.guiTop + 6;
        this.titleHoverChecker = new HoverChecker(titleY, titleY + this.field_146289_q.field_78288_b, titleX, titleX + titleWidth, 0);
        int spacingY = recipeBackground.getHeight() + recipeSpacing;
        this.recipeLayouts.clear();
        this.recipeLayouts.addAll(this.logic.getRecipeLayouts(recipeXOffset, this.guiTop + this.headerHeight + recipeSpacing, spacingY));
        this.addRecipeTransferButtons(this.recipeLayouts);
        this.nextPage.field_146124_l = this.previousPage.field_146124_l = this.logic.hasMultiplePages();
        this.nextRecipeCategory.field_146124_l = this.previousRecipeCategory.field_146124_l = this.logic.hasMultipleCategories();
        this.pageString = this.logic.getPageString();
        List<ItemStack> recipeCategoryCraftingItems = this.logic.getRecipeCategoryCraftingItems();
        GuiProperties guiProperties = GuiProperties.create(this);
        this.recipeCategoryCraftingItems.updateLayout(recipeCategoryCraftingItems, guiProperties);
        this.recipeGuiTabs.updateLayout(guiProperties);
    }

    private void addRecipeTransferButtons(List<RecipeLayout> recipeLayouts) {
        this.field_146292_n.clear();
        this.addButtons();
        EntityPlayerSP player = this.field_146297_k.field_71439_g;
        Container container = this.getParentContainer();
        for (RecipeLayout recipeLayout : recipeLayouts) {
            RecipeTransferButton button = recipeLayout.getRecipeTransferButton();
            if (button == null) continue;
            button.init(container, (EntityPlayer)player);
            this.field_146292_n.add(button);
        }
    }

    @Nullable
    public GuiScreen getParentScreen() {
        return this.parentScreen;
    }

    @Nullable
    private Container getParentContainer() {
        if (this.parentScreen instanceof GuiContainer) {
            return ((GuiContainer)this.parentScreen).field_147002_h;
        }
        return null;
    }

    @Override
    public void onStateChange() {
        this.updateLayout();
    }
}

