/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.JustEnoughItems;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.config.Config;
import mezz.jei.config.Constants;
import mezz.jei.config.JEIModConfigGui;
import mezz.jei.gui.GuiHelper;
import mezz.jei.gui.GuiProperties;
import mezz.jei.gui.ItemListOverlay;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.GuiIngredientFast;
import mezz.jei.gui.ingredients.GuiIngredientFastList;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.GuiTextFieldFilter;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.network.packets.PacketDeletePlayerItem;
import mezz.jei.util.Java6Helper;
import mezz.jei.util.MathUtil;
import mezz.jei.util.StackHelper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.HoverChecker;
import org.lwjgl.input.Keyboard;

public class ItemListOverlayInternal
implements IShowsRecipeFocuses,
IMouseHandler {
    private static final int borderPadding = 2;
    private static final int searchHeight = 16;
    private static final int buttonSize = 20;
    private static final String nextLabel = ">";
    private static final String backLabel = "<";
    private static final int itemStackPadding = 1;
    private static final int itemStackWidth = GuiItemStackGroup.getWidth(1);
    private static final int itemStackHeight = GuiItemStackGroup.getHeight(1);
    private static int firstItemIndex = 0;
    private final ItemListOverlay parent;
    private final GuiButton nextButton;
    private final GuiButton backButton;
    private final GuiButton configButton;
    private final IDrawable configButtonIcon;
    private final IDrawable configButtonCheatIcon;
    private final HoverChecker configButtonHoverChecker;
    private final GuiTextFieldFilter searchField;
    private String pageNumDisplayString = "1/1";
    private int pageNumDisplayX;
    private int pageNumDisplayY;
    private final GuiIngredientFastList guiIngredientList;
    @Nullable
    private GuiIngredientFast hovered = null;
    private final GuiProperties guiProperties;
    private final List<Rectangle> guiAreas;
    private List<IAdvancedGuiHandler<?>> activeAdvancedGuiHandlers = Collections.emptyList();

    public ItemListOverlayInternal(ItemListOverlay parent, IIngredientRegistry ingredientRegistry, GuiScreen guiScreen, GuiProperties guiProperties) {
        int searchFieldWidth;
        int searchFieldX;
        this.parent = parent;
        this.guiIngredientList = new GuiIngredientFastList(ingredientRegistry);
        this.guiProperties = guiProperties;
        this.activeAdvancedGuiHandlers = this.getActiveAdvancedGuiHandlers(guiScreen);
        if (!this.activeAdvancedGuiHandlers.isEmpty() && guiScreen instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)guiScreen;
            this.guiAreas = this.getGuiAreas(guiContainer);
        } else {
            this.guiAreas = Collections.emptyList();
        }
        int columns = ItemListOverlayInternal.getColumns(guiProperties);
        int rows = ItemListOverlayInternal.getRows(guiProperties);
        int xSize = columns * itemStackWidth;
        int xEmptySpace = guiProperties.getScreenWidth() - guiProperties.getGuiLeft() - guiProperties.getGuiXSize() - xSize;
        int leftEdge = guiProperties.getGuiLeft() + guiProperties.getGuiXSize() + xEmptySpace / 2;
        int rightEdge = leftEdge + xSize;
        int yItemButtonSpace = ItemListOverlayInternal.getItemButtonYSpace(guiProperties);
        int itemButtonsHeight = rows * itemStackHeight;
        int buttonStartY = 24 + (yItemButtonSpace - itemButtonsHeight) / 2;
        ItemListOverlayInternal.createItemButtons(this.guiIngredientList, this.guiAreas, leftEdge, buttonStartY, columns, rows);
        this.nextButton = new GuiButton(0, rightEdge - 20, 2, 20, 20, nextLabel);
        this.backButton = new GuiButton(1, leftEdge, 2, 20, 20, backLabel);
        int searchFieldY = guiProperties.getScreenHeight() - 16 - 2 - 2;
        if (ItemListOverlayInternal.isSearchBarCentered(guiProperties)) {
            searchFieldX = guiProperties.getGuiLeft();
            searchFieldWidth = guiProperties.getGuiXSize() - 20 - 1;
        } else {
            searchFieldX = leftEdge;
            searchFieldWidth = rightEdge - leftEdge - 20 - 1;
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.searchField = new GuiTextFieldFilter(0, fontRenderer, searchFieldX, searchFieldY, searchFieldWidth, 16, parent.getItemFilter());
        this.setKeyboardFocus(false);
        int configButtonX = searchFieldX + searchFieldWidth + 1;
        int configButtonY = guiProperties.getScreenHeight() - 20 - 2;
        this.configButton = new GuiButton(2, configButtonX, configButtonY, 20, 20, "");
        ResourceLocation configButtonIconLocation = new ResourceLocation(Constants.RESOURCE_DOMAIN, "textures/gui/recipe_background.png");
        GuiHelper guiHelper = Internal.getHelpers().getGuiHelper();
        this.configButtonIcon = guiHelper.createDrawable(configButtonIconLocation, 0, 166, 16, 16);
        this.configButtonCheatIcon = guiHelper.createDrawable(configButtonIconLocation, 16, 166, 16, 16);
        this.configButtonHoverChecker = new HoverChecker(this.configButton, 0);
        this.updateLayout();
    }

    private static boolean isSearchBarCentered(GuiProperties guiProperties) {
        return Config.isCenterSearchBarEnabled() && guiProperties.getGuiTop() + guiProperties.getGuiYSize() + 16 < guiProperties.getScreenHeight();
    }

    private List<IAdvancedGuiHandler<?>> getActiveAdvancedGuiHandlers(GuiScreen guiScreen) {
        ArrayList activeAdvancedGuiHandler = new ArrayList();
        if (guiScreen instanceof GuiContainer) {
            for (IAdvancedGuiHandler<?> advancedGuiHandler : this.parent.getAdvancedGuiHandlers()) {
                Class<?> guiContainerClass = advancedGuiHandler.getGuiContainerClass();
                if (!guiContainerClass.isInstance(guiScreen)) continue;
                activeAdvancedGuiHandler.add(advancedGuiHandler);
            }
        }
        return activeAdvancedGuiHandler;
    }

    private List<Rectangle> getGuiAreas(GuiContainer guiContainer) {
        ArrayList<Rectangle> guiAreas = new ArrayList<Rectangle>();
        for (IAdvancedGuiHandler<?> advancedGuiHandler : this.activeAdvancedGuiHandlers) {
            List<Rectangle> guiExtraAreas = this.getGuiAreas(guiContainer, advancedGuiHandler);
            if (guiExtraAreas == null) continue;
            guiAreas.addAll(guiExtraAreas);
        }
        return guiAreas;
    }

    @Nullable
    private <T extends GuiContainer> List<Rectangle> getGuiAreas(GuiContainer gui, IAdvancedGuiHandler<T> advancedGuiHandler) {
        Class<T> guiClass = advancedGuiHandler.getGuiContainerClass();
        if (guiClass.isInstance(gui)) {
            GuiContainer guiT = (GuiContainer)guiClass.cast(gui);
            return advancedGuiHandler.getGuiExtraAreas(guiT);
        }
        return null;
    }

    public boolean hasScreenChanged(GuiScreen guiScreen) {
        GuiContainer guiContainer;
        List<Rectangle> guiAreas;
        if (!Config.isOverlayEnabled()) {
            return true;
        }
        GuiProperties guiProperties = GuiProperties.create(guiScreen);
        if (guiProperties == null) {
            return true;
        }
        if (!this.guiProperties.equals(guiProperties)) {
            return true;
        }
        return !this.activeAdvancedGuiHandlers.isEmpty() && guiScreen instanceof GuiContainer && !Java6Helper.equals(this.guiAreas, guiAreas = this.getGuiAreas(guiContainer = (GuiContainer)guiScreen));
    }

    private static void createItemButtons(GuiIngredientFastList guiItemStacks, @Nullable List<Rectangle> guiAreas, int xStart, int yStart, int columnCount, int rowCount) {
        guiItemStacks.clear();
        for (int row = 0; row < rowCount; ++row) {
            int y = yStart + row * itemStackHeight;
            for (int column = 0; column < columnCount; ++column) {
                Rectangle stackArea;
                int x = xStart + column * itemStackWidth;
                GuiIngredientFast guiIngredientFast = new GuiIngredientFast(x, y, 1);
                if (guiAreas != null && ItemListOverlayInternal.intersects(guiAreas, stackArea = guiIngredientFast.getArea())) continue;
                guiItemStacks.add(guiIngredientFast);
            }
        }
    }

    private static boolean intersects(List<Rectangle> areas, Rectangle comparisonArea) {
        for (Rectangle area : areas) {
            if (!area.intersects(comparisonArea)) continue;
            return true;
        }
        return false;
    }

    public void updateLayout() {
        ImmutableList<IIngredientListElement> ingredientList = this.parent.getItemFilter().getIngredientList();
        this.guiIngredientList.set(firstItemIndex, (List<IIngredientListElement>)ingredientList);
        FontRenderer fontRendererObj = Minecraft.func_71410_x().field_71466_p;
        this.pageNumDisplayString = this.getPageNum() + 1 + "/" + this.getPageCount();
        int pageDisplayWidth = fontRendererObj.func_78256_a(this.pageNumDisplayString);
        this.pageNumDisplayX = (this.backButton.field_146128_h + this.backButton.field_146120_f + this.nextButton.field_146128_h) / 2 - pageDisplayWidth / 2;
        this.pageNumDisplayY = this.backButton.field_146129_i + Math.round((float)(this.backButton.field_146121_g - fontRendererObj.field_78288_b) / 2.0f);
        this.searchField.update();
    }

    private void nextPage() {
        int itemsCount = this.parent.getItemFilter().size();
        if (itemsCount == 0) {
            firstItemIndex = 0;
            return;
        }
        if ((firstItemIndex += this.guiIngredientList.size()) >= itemsCount) {
            firstItemIndex = 0;
        }
        this.updateLayout();
    }

    private void previousPage() {
        int itemsPerPage = this.guiIngredientList.size();
        if (itemsPerPage == 0) {
            firstItemIndex = 0;
            return;
        }
        int itemsCount = this.parent.getItemFilter().size();
        int pageNum = firstItemIndex / itemsPerPage;
        pageNum = pageNum == 0 ? itemsCount / itemsPerPage : --pageNum;
        firstItemIndex = itemsPerPage * pageNum;
        if (firstItemIndex > 0 && firstItemIndex == itemsCount) {
            firstItemIndex = itemsPerPage * --pageNum;
        }
        this.updateLayout();
    }

    public void drawScreen(Minecraft minecraft, int mouseX, int mouseY) {
        GlStateManager.func_179140_f();
        minecraft.field_71466_p.func_175065_a(this.pageNumDisplayString, (float)this.pageNumDisplayX, (float)this.pageNumDisplayY, Color.white.getRGB(), true);
        this.searchField.func_146194_f();
        this.nextButton.func_146112_a(minecraft, mouseX, mouseY);
        this.backButton.func_146112_a(minecraft, mouseX, mouseY);
        this.configButton.func_146112_a(minecraft, mouseX, mouseY);
        IDrawable icon = Config.isCheatItemsEnabled() ? this.configButtonCheatIcon : this.configButtonIcon;
        icon.draw(minecraft, this.configButton.field_146128_h + 2, this.configButton.field_146129_i + 2);
        GlStateManager.func_179084_k();
        if (this.shouldShowDeleteItemTooltip(minecraft)) {
            this.hovered = this.guiIngredientList.render(minecraft, false, mouseX, mouseY);
        } else {
            boolean mouseOver = this.isMouseOver(mouseX, mouseY);
            this.hovered = this.guiIngredientList.render(minecraft, mouseOver, mouseX, mouseY);
        }
        Set<ItemStack> highlightedStacks = this.parent.getHighlightedStacks();
        if (!highlightedStacks.isEmpty()) {
            StackHelper helper = Internal.getHelpers().getStackHelper();
            for (GuiIngredientFast guiItemStack : this.guiIngredientList.getAllGuiIngredients()) {
                Object ingredient = guiItemStack.getIngredient();
                if (!(ingredient instanceof ItemStack) || helper.containsStack(highlightedStacks, (ItemStack)ingredient) == null) continue;
                guiItemStack.drawHighlight();
            }
        }
        if (this.hovered != null) {
            this.hovered.drawHovered(minecraft);
        }
        GlStateManager.func_179141_d();
    }

    private boolean shouldShowDeleteItemTooltip(Minecraft minecraft) {
        if (Config.isDeleteItemsInCheatModeActive()) {
            EntityPlayerSP player = minecraft.field_71439_g;
            if (!player.field_71071_by.func_70445_o().func_190926_b()) {
                return true;
            }
        }
        return false;
    }

    public void drawTooltips(Minecraft minecraft, int mouseX, int mouseY) {
        boolean mouseOver = this.isMouseOver(mouseX, mouseY);
        if (mouseOver && this.shouldShowDeleteItemTooltip(minecraft)) {
            String deleteItem = Translator.translateToLocal("jei.tooltip.delete.item");
            TooltipRenderer.drawHoveringText(minecraft, deleteItem, mouseX, mouseY);
        }
        if (this.hovered != null) {
            this.hovered.drawTooltip(minecraft, mouseX, mouseY);
        }
        if (this.configButtonHoverChecker.checkHover(mouseX, mouseY)) {
            String configString = Translator.translateToLocal("jei.tooltip.config");
            if (Config.isCheatItemsEnabled()) {
                List<String> tooltip = Arrays.asList(configString, TextFormatting.RED + Translator.translateToLocal("jei.tooltip.cheat.mode"));
                TooltipRenderer.drawHoveringText(minecraft, tooltip, mouseX, mouseY);
            } else {
                TooltipRenderer.drawHoveringText(minecraft, configString, mouseX, mouseY);
            }
        }
    }

    public void handleTick() {
        this.searchField.func_146178_a();
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        if (mouseX < this.guiProperties.getGuiLeft() + this.guiProperties.getGuiXSize()) {
            return ItemListOverlayInternal.isSearchBarCentered(this.guiProperties) && (this.searchField.isMouseOver(mouseX, mouseY) || this.configButtonHoverChecker.checkHover(mouseX, mouseY));
        }
        for (Rectangle guiArea : this.guiAreas) {
            if (!guiArea.contains(mouseX, mouseY)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(int mouseX, int mouseY) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return null;
        }
        ClickedIngredient<?> clicked = this.guiIngredientList.getIngredientUnderMouse(mouseX, mouseY);
        if (clicked != null) {
            this.setKeyboardFocus(false);
            clicked.setAllowsCheating();
        }
        return clicked;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return true;
    }

    @Override
    public boolean handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean buttonClicked;
        if (!this.isMouseOver(mouseX, mouseY)) {
            this.setKeyboardFocus(false);
            return false;
        }
        if (Config.isDeleteItemsInCheatModeActive()) {
            Minecraft minecraft = Minecraft.func_71410_x();
            EntityPlayerSP player = minecraft.field_71439_g;
            ItemStack itemStack = player.field_71071_by.func_70445_o();
            if (!itemStack.func_190926_b()) {
                player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                PacketDeletePlayerItem packet = new PacketDeletePlayerItem(itemStack);
                JustEnoughItems.getProxy().sendPacketToServer(packet);
                return true;
            }
        }
        if (buttonClicked = this.handleMouseClickedButtons(mouseX, mouseY)) {
            this.setKeyboardFocus(false);
            return true;
        }
        return this.handleMouseClickedSearch(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean handleMouseScrolled(int mouseX, int mouseY, int scrollDelta) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (scrollDelta < 0) {
            this.nextPage();
            return true;
        }
        if (scrollDelta > 0) {
            this.previousPage();
            return true;
        }
        return false;
    }

    private boolean handleMouseClickedButtons(int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (this.nextButton.func_146116_c(minecraft, mouseX, mouseY)) {
            this.nextPage();
            this.nextButton.func_146113_a(minecraft.func_147118_V());
            return true;
        }
        if (this.backButton.func_146116_c(minecraft, mouseX, mouseY)) {
            this.previousPage();
            this.backButton.func_146113_a(minecraft.func_147118_V());
            return true;
        }
        if (this.configButton.func_146116_c(minecraft, mouseX, mouseY)) {
            this.configButton.func_146113_a(minecraft.func_147118_V());
            if (Keyboard.getEventKeyState() && (Keyboard.getEventKey() == 29 || Keyboard.getEventKey() == 157)) {
                Config.toggleCheatItemsEnabled();
            } else if (minecraft.field_71462_r != null) {
                this.parent.close();
                JEIModConfigGui configScreen = new JEIModConfigGui(minecraft.field_71462_r);
                minecraft.func_147108_a((GuiScreen)configScreen);
            }
            return true;
        }
        return false;
    }

    private boolean handleMouseClickedSearch(int mouseX, int mouseY, int mouseButton) {
        boolean searchClicked = this.searchField.isMouseOver(mouseX, mouseY);
        this.setKeyboardFocus(searchClicked);
        if (searchClicked && this.searchField.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            this.updateLayout();
        }
        return searchClicked;
    }

    public boolean hasKeyboardFocus() {
        return this.searchField.func_146206_l();
    }

    public void setKeyboardFocus(boolean keyboardFocus) {
        this.searchField.func_146195_b(keyboardFocus);
    }

    public boolean onKeyPressed(char typedChar, int keyCode) {
        if (this.hasKeyboardFocus()) {
            boolean changed;
            boolean handled = this.searchField.func_146201_a(typedChar, keyCode);
            if (handled && (changed = Config.setFilterText(this.searchField.func_146179_b()))) {
                firstItemIndex = 0;
                this.updateLayout();
            }
            return handled;
        }
        return false;
    }

    private static int getItemButtonXSpace(GuiProperties guiProperties) {
        return guiProperties.getScreenWidth() - (guiProperties.getGuiLeft() + guiProperties.getGuiXSize() + 4);
    }

    private static int getItemButtonYSpace(GuiProperties guiProperties) {
        if (ItemListOverlayInternal.isSearchBarCentered(guiProperties)) {
            return guiProperties.getScreenHeight() - 26;
        }
        return guiProperties.getScreenHeight() - 46;
    }

    public static int getColumns(GuiProperties guiProperties) {
        return ItemListOverlayInternal.getItemButtonXSpace(guiProperties) / itemStackWidth;
    }

    public static int getRows(GuiProperties guiProperties) {
        return ItemListOverlayInternal.getItemButtonYSpace(guiProperties) / itemStackHeight;
    }

    private int getPageCount() {
        int itemCount = this.parent.getItemFilter().size();
        int stacksPerPage = this.guiIngredientList.size();
        if (stacksPerPage == 0) {
            return 1;
        }
        int pageCount = MathUtil.divideCeil(itemCount, stacksPerPage);
        pageCount = Math.max(1, pageCount);
        return pageCount;
    }

    private int getPageNum() {
        int stacksPerPage = this.guiIngredientList.size();
        if (stacksPerPage == 0) {
            return 1;
        }
        return firstItemIndex / stacksPerPage;
    }

    public void close() {
        this.setKeyboardFocus(false);
        Config.saveFilterText();
    }

    @Nullable
    public ItemStack getStackUnderMouse() {
        Object ingredient;
        if (this.hovered != null && (ingredient = this.hovered.getIngredient()) instanceof ItemStack) {
            return (ItemStack)ingredient;
        }
        return null;
    }

    public void setFilterText(String filterText) {
        this.searchField.func_146180_a(filterText);
        ItemListOverlayInternal.setToFirstPage();
        this.updateLayout();
    }

    public static void setToFirstPage() {
        firstItemIndex = 0;
    }

    public ImmutableList<ItemStack> getVisibleStacks() {
        ImmutableList.Builder visibleStacks = ImmutableList.builder();
        for (GuiIngredientFast guiItemStack : this.guiIngredientList.getAllGuiIngredients()) {
            Object ingredient = guiItemStack.getIngredient();
            if (!(ingredient instanceof ItemStack)) continue;
            ItemStack itemStack = (ItemStack)ingredient;
            visibleStacks.add((Object)itemStack);
        }
        return visibleStacks.build();
    }
}

