/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.util.Log;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class SubtypeRegistry
implements ISubtypeRegistry {
    private final Map<Item, ISubtypeRegistry.ISubtypeInterpreter> interpreters = new HashMap<Item, ISubtypeRegistry.ISubtypeInterpreter>();

    @Override
    public void useNbtForSubtypes(Item ... items) {
        for (Item item : items) {
            this.registerNbtInterpreter(item, AllNbt.INSTANCE);
        }
    }

    @Override
    public void registerNbtInterpreter(@Nullable Item item, @Nullable ISubtypeRegistry.ISubtypeInterpreter interpreter) {
        if (item == null) {
            Log.error("Null item", new NullPointerException());
            return;
        }
        if (interpreter == null) {
            Log.error("Null interpreter", new NullPointerException());
            return;
        }
        if (this.interpreters.containsKey(item)) {
            Log.error("An interpreter is already registered for this item: {}", item, new IllegalArgumentException());
            return;
        }
        this.interpreters.put(item, interpreter);
    }

    @Override
    @Nullable
    public String getSubtypeInfo(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            Log.error("Null itemStack", new NullPointerException());
            return null;
        }
        if (itemStack.func_190926_b()) {
            Log.error("Invalid ItemStack", new IllegalArgumentException());
            return null;
        }
        Item item = itemStack.func_77973_b();
        ISubtypeRegistry.ISubtypeInterpreter nbtInterpreter = this.interpreters.get(item);
        if (nbtInterpreter != null) {
            return nbtInterpreter.getSubtypeInfo(itemStack);
        }
        if (itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            IFluidHandler capability = (IFluidHandler)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            IFluidTankProperties[] tankPropertiesList = capability.getTankProperties();
            StringBuilder info = new StringBuilder();
            for (IFluidTankProperties tankProperties : tankPropertiesList) {
                String contentsName = SubtypeRegistry.getContentsName(tankProperties);
                if (contentsName != null) {
                    info.append(contentsName).append(";");
                    continue;
                }
                info.append("empty").append(";");
            }
            if (info.length() > 0) {
                return info.toString();
            }
        }
        return null;
    }

    @Nullable
    private static String getContentsName(IFluidTankProperties fluidTankProperties) {
        Fluid fluid;
        FluidStack contents = fluidTankProperties.getContents();
        if (contents != null && (fluid = contents.getFluid()) != null) {
            return fluid.getName();
        }
        return null;
    }

    private static class AllNbt
    implements ISubtypeRegistry.ISubtypeInterpreter {
        public static final AllNbt INSTANCE = new AllNbt();

        private AllNbt() {
        }

        @Override
        @Nullable
        public String getSubtypeInfo(ItemStack itemStack) {
            NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
            if (nbtTagCompound == null || nbtTagCompound.func_82582_d()) {
                return null;
            }
            return nbtTagCompound.toString();
        }
    }
}

