/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.JeiRuntime;
import mezz.jei.JeiStarter;
import mezz.jei.ProxyCommon;
import mezz.jei.api.IModPlugin;
import mezz.jei.config.Config;
import mezz.jei.config.KeyBindings;
import mezz.jei.config.SessionData;
import mezz.jei.gui.ItemListOverlay;
import mezz.jei.network.packets.PacketJei;
import mezz.jei.plugins.jei.JEIInternalPlugin;
import mezz.jei.plugins.vanilla.VanillaPlugin;
import mezz.jei.util.AnnotatedInstanceUtil;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ProxyCommonClient
extends ProxyCommon {
    private List<IModPlugin> plugins = new ArrayList<IModPlugin>();
    private final JeiStarter starter = new JeiStarter();

    private static void initVersionChecker() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("curseProjectName", "just-enough-items-jei");
        compound.func_74778_a("curseFilenameParser", "jei_1.11-[].jar");
        FMLInterModComms.sendRuntimeMessage((Object)"jei", (String)"VersionChecker", (String)"addCurseCheck", (NBTTagCompound)compound);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        IModPlugin jeiInternalPlugin;
        super.preInit(event);
        Config.preInit(event);
        ProxyCommonClient.initVersionChecker();
        ASMDataTable asmDataTable = event.getAsmData();
        this.plugins = AnnotatedInstanceUtil.getModPlugins(asmDataTable);
        IModPlugin vanillaPlugin = this.getVanillaPlugin(this.plugins);
        if (vanillaPlugin != null) {
            this.plugins.remove(vanillaPlugin);
            this.plugins.add(0, vanillaPlugin);
        }
        if ((jeiInternalPlugin = this.getJeiInternalPlugin(this.plugins)) != null) {
            this.plugins.remove(jeiInternalPlugin);
            this.plugins.add(jeiInternalPlugin);
        }
    }

    @Nullable
    private IModPlugin getVanillaPlugin(List<IModPlugin> modPlugins) {
        for (IModPlugin modPlugin : modPlugins) {
            if (!(modPlugin instanceof VanillaPlugin)) continue;
            return modPlugin;
        }
        return null;
    }

    @Nullable
    private IModPlugin getJeiInternalPlugin(List<IModPlugin> modPlugins) {
        for (IModPlugin modPlugin : modPlugins) {
            if (!(modPlugin instanceof JEIInternalPlugin)) continue;
            return modPlugin;
        }
        return null;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        KeyBindings.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void loadComplete(FMLLoadCompleteEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        IReloadableResourceManager reloadableResourceManager = (IReloadableResourceManager)minecraft.func_110442_L();
        reloadableResourceManager.func_110542_a(new IResourceManagerReloadListener(){

            public void func_110549_a(IResourceManager resourceManager) {
                if (SessionData.hasJoinedWorld()) {
                    ProxyCommonClient.this.restartJEI(true);
                }
            }
        });
        try {
            this.starter.start(this.plugins, true, false);
        }
        catch (Exception e) {
            Log.error("Exception on load", e);
        }
    }

    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K && !SessionData.hasJoinedWorld() && Minecraft.func_71410_x().field_71439_g != null) {
            SessionData.setJoinedWorld();
            Config.syncWorldConfig();
        }
    }

    @Override
    public void restartJEI() {
        this.restartJEI(false);
    }

    private void restartJEI(final boolean resourceReload) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.func_152345_ab()) {
            if (this.starter.hasStarted()) {
                this.starter.start(this.plugins, false, resourceReload);
            }
        } else {
            Log.error("A mod is trying to restart JEI from the wrong thread!", new RuntimeException());
            minecraft.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    ProxyCommonClient.this.restartJEI(resourceReload);
                }
            });
        }
    }

    private static void reloadItemList() {
        JeiRuntime runtime = Internal.getRuntime();
        if (runtime != null) {
            ItemListOverlay itemListOverlay = runtime.getItemListOverlay();
            itemListOverlay.rebuildItemFilter();
        }
    }

    @Override
    public void sendPacketToServer(PacketJei packet) {
        NetHandlerPlayClient netHandler = FMLClientHandler.instance().getClient().func_147114_u();
        if (netHandler != null && SessionData.isJeiOnServer()) {
            netHandler.func_147297_a((Packet)packet.getPacket());
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (!"jei".equals(eventArgs.getModID())) {
            return;
        }
        if (Config.syncAllConfig()) {
            ProxyCommonClient.reloadItemList();
        }
    }
}

