/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.util.ErrorUtil;

public class ModIngredientRegistration
implements IModIngredientRegistration {
    private final Map<Class, Collection> allIngredientsMap = new IdentityHashMap<Class, Collection>();
    private final Map<Class, IIngredientHelper> ingredientHelperMap = new IdentityHashMap<Class, IIngredientHelper>();
    private final Map<Class, IIngredientRenderer> ingredientRendererMap = new IdentityHashMap<Class, IIngredientRenderer>();

    @Override
    public <V> void register(Class<V> ingredientClass, Collection<V> allIngredients, IIngredientHelper<V> ingredientHelper, IIngredientRenderer<V> ingredientRenderer) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        ErrorUtil.checkNotNull(allIngredients, "allIngredients");
        ErrorUtil.checkNotNull(ingredientHelper, "ingredientHelper");
        ErrorUtil.checkNotNull(ingredientRenderer, "ingredientRenderer");
        this.allIngredientsMap.put(ingredientClass, allIngredients);
        this.ingredientHelperMap.put(ingredientClass, ingredientHelper);
        this.ingredientRendererMap.put(ingredientClass, ingredientRenderer);
    }

    public IngredientRegistry createIngredientRegistry() {
        IdentityHashMap<Class, List> ingredientsMap = new IdentityHashMap<Class, List>();
        for (Class ingredientClass : this.allIngredientsMap.keySet()) {
            Collection ingredients = this.allIngredientsMap.get(ingredientClass);
            ingredientsMap.put(ingredientClass, Lists.newArrayList((Iterable)ingredients));
        }
        return new IngredientRegistry(ingredientsMap, (ImmutableMap<Class, IIngredientHelper>)ImmutableMap.copyOf(this.ingredientHelperMap), (ImmutableMap<Class, IIngredientRenderer>)ImmutableMap.copyOf(this.ingredientRendererMap));
    }
}

