/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import java.util.Iterator;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.gui.GuiEventHandler;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.ingredients.IngredientLookupMemory;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientListElementFactory;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.plugins.vanilla.VanillaPlugin;
import mezz.jei.recipes.RecipeRegistry;
import mezz.jei.runtime.JeiHelpers;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.runtime.SubtypeRegistry;
import mezz.jei.startup.ForgeModIdHelper;
import mezz.jei.startup.ModIngredientRegistration;
import mezz.jei.startup.ModRegistry;
import mezz.jei.startup.StackHelper;
import mezz.jei.util.Log;
import net.minecraftforge.fml.common.ProgressManager;

public class JeiStarter {
    private boolean started;

    public void start(List<IModPlugin> plugins) {
        long jeiStartTime = System.currentTimeMillis();
        Log.info("Starting JEI...", new Object[0]);
        SubtypeRegistry subtypeRegistry = new SubtypeRegistry();
        JeiStarter.registerItemSubtypes(plugins, subtypeRegistry);
        StackHelper stackHelper = new StackHelper(subtypeRegistry);
        stackHelper.enableUidCache();
        Internal.setStackHelper(stackHelper);
        IngredientRegistry ingredientRegistry = JeiStarter.registerIngredients(plugins);
        Internal.setIngredientRegistry(ingredientRegistry);
        JeiHelpers jeiHelpers = new JeiHelpers(ingredientRegistry, stackHelper);
        Internal.setHelpers(jeiHelpers);
        ModRegistry modRegistry = new ModRegistry(jeiHelpers, ingredientRegistry);
        JeiStarter.registerCategories(plugins, modRegistry);
        JeiStarter.registerPlugins(plugins, modRegistry);
        Log.info("Building recipe registry...", new Object[0]);
        long start_time = System.currentTimeMillis();
        RecipeRegistry recipeRegistry = modRegistry.createRecipeRegistry(ingredientRegistry);
        Log.info("Built    recipe registry in {} ms", System.currentTimeMillis() - start_time);
        Log.info("Loading ingredient lookup history...", new Object[0]);
        start_time = System.currentTimeMillis();
        Internal.setIngredientLookupMemory(new IngredientLookupMemory(recipeRegistry, ingredientRegistry));
        Log.info("Loaded  ingredient lookup history in {} ms", System.currentTimeMillis() - start_time);
        Log.info("Building ingredient list...", new Object[0]);
        start_time = System.currentTimeMillis();
        List<IIngredientListElement> ingredientList = IngredientListElementFactory.createBaseList(ingredientRegistry, ForgeModIdHelper.getInstance());
        Log.info("Built    ingredient list in {} ms", System.currentTimeMillis() - start_time);
        Log.info("Building ingredient filter...", new Object[0]);
        start_time = System.currentTimeMillis();
        IngredientFilter ingredientFilter = new IngredientFilter(jeiHelpers);
        ingredientFilter.addIngredients(ingredientList);
        Internal.setIngredientFilter(ingredientFilter);
        Log.info("Built    ingredient filter in {} ms", System.currentTimeMillis() - start_time);
        Log.info("Building runtime...", new Object[0]);
        start_time = System.currentTimeMillis();
        List<IAdvancedGuiHandler<?>> advancedGuiHandlers = modRegistry.getAdvancedGuiHandlers();
        IngredientListOverlay ingredientListOverlay = new IngredientListOverlay(ingredientFilter, ingredientRegistry);
        RecipesGui recipesGui = new RecipesGui(recipeRegistry);
        JeiRuntime jeiRuntime = new JeiRuntime(recipeRegistry, ingredientListOverlay, recipesGui, ingredientRegistry, advancedGuiHandlers, ingredientFilter);
        Internal.setRuntime(jeiRuntime);
        Log.info("Built    runtime in {} ms", System.currentTimeMillis() - start_time);
        stackHelper.disableUidCache();
        JeiStarter.sendRuntime(plugins, jeiRuntime);
        GuiEventHandler guiEventHandler = new GuiEventHandler(jeiRuntime);
        Internal.setGuiEventHandler(guiEventHandler);
        this.started = true;
        Log.info("Finished Starting JEI in {} ms", System.currentTimeMillis() - jeiStartTime);
    }

    public boolean hasStarted() {
        return this.started;
    }

    private static void registerItemSubtypes(List<IModPlugin> plugins, SubtypeRegistry subtypeRegistry) {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Registering item subtypes", (int)plugins.size());
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                progressBar.step(plugin.getClass().getName());
                plugin.registerItemSubtypes(subtypeRegistry);
            }
            catch (RuntimeException e) {
                Log.error("Failed to register item subtypes for mod plugin: {}", plugin.getClass(), e);
                iterator.remove();
            }
            catch (LinkageError e) {
                Log.error("Failed to register item subtypes for mod plugin: {}", plugin.getClass(), e);
                iterator.remove();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    private static IngredientRegistry registerIngredients(List<IModPlugin> plugins) {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Registering ingredients", (int)plugins.size());
        ModIngredientRegistration modIngredientRegistry = new ModIngredientRegistration();
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                progressBar.step(plugin.getClass().getName());
                plugin.registerIngredients(modIngredientRegistry);
            }
            catch (RuntimeException e) {
                if (VanillaPlugin.class.isInstance(plugin)) {
                    throw e;
                }
                Log.error("Failed to register Ingredients for mod plugin: {}", plugin.getClass(), e);
                iterator.remove();
            }
            catch (LinkageError e) {
                if (VanillaPlugin.class.isInstance(plugin)) {
                    throw e;
                }
                Log.error("Failed to register Ingredients for mod plugin: {}", plugin.getClass(), e);
                iterator.remove();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        return modIngredientRegistry.createIngredientRegistry();
    }

    private static void registerCategories(List<IModPlugin> plugins, ModRegistry modRegistry) {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Registering categories", (int)plugins.size());
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                progressBar.step(plugin.getClass().getName());
                long start_time = System.currentTimeMillis();
                Log.info("Registering categories: {} ...", plugin.getClass().getName());
                plugin.registerCategories(modRegistry);
                long timeElapsedMs = System.currentTimeMillis() - start_time;
                Log.info("Registered  categories: {} in {} ms", plugin.getClass().getName(), timeElapsedMs);
            }
            catch (AbstractMethodError start_time) {
            }
            catch (RuntimeException e) {
                Log.error("Failed to register mod categories: {}", plugin.getClass(), e);
                iterator.remove();
            }
            catch (LinkageError e) {
                Log.error("Failed to register mod categories: {}", plugin.getClass(), e);
                iterator.remove();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    private static void registerPlugins(List<IModPlugin> plugins, ModRegistry modRegistry) {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Registering plugins", (int)plugins.size());
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                progressBar.step(plugin.getClass().getName());
                long start_time = System.currentTimeMillis();
                Log.info("Registering plugin: {} ...", plugin.getClass().getName());
                plugin.register(modRegistry);
                long timeElapsedMs = System.currentTimeMillis() - start_time;
                Log.info("Registered  plugin: {} in {} ms", plugin.getClass().getName(), timeElapsedMs);
            }
            catch (RuntimeException e) {
                Log.error("Failed to register mod plugin: {}", plugin.getClass(), e);
                iterator.remove();
            }
            catch (LinkageError e) {
                Log.error("Failed to register mod plugin: {}", plugin.getClass(), e);
                iterator.remove();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    private static void sendRuntime(List<IModPlugin> plugins, IJeiRuntime jeiRuntime) {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Sending Runtime", (int)plugins.size());
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                progressBar.step(plugin.getClass().getName());
                long start_time = System.currentTimeMillis();
                Log.info("Sending runtime to plugin: {} ...", plugin.getClass().getName());
                plugin.onRuntimeAvailable(jeiRuntime);
                long timeElapsedMs = System.currentTimeMillis() - start_time;
                if (timeElapsedMs <= 100L) continue;
                Log.warning("Sending runtime to plugin: {} took {} ms", plugin.getClass().getName(), timeElapsedMs);
            }
            catch (RuntimeException e) {
                Log.error("Sending runtime to plugin failed: {}", plugin.getClass(), e);
                iterator.remove();
            }
            catch (LinkageError e) {
                Log.error("Sending runtime to plugin failed: {}", plugin.getClass(), e);
                iterator.remove();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }
}

