/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientListElementFactory;
import mezz.jei.startup.ForgeModIdHelper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import net.minecraft.tileentity.TileEntityFurnace;

public class IngredientRegistry
implements IIngredientRegistry {
    private final Map<Class, List> ingredientsMap;
    private final ImmutableMap<Class, IIngredientHelper> ingredientHelperMap;
    private final ImmutableMap<Class, IIngredientRenderer> ingredientRendererMap;
    private final List<ItemStack> fuels = new ArrayList<ItemStack>();
    private final List<ItemStack> potionIngredients = new ArrayList<ItemStack>();

    public IngredientRegistry(Map<Class, List> ingredientsMap, ImmutableMap<Class, IIngredientHelper> ingredientHelperMap, ImmutableMap<Class, IIngredientRenderer> ingredientRendererMap) {
        this.ingredientsMap = ingredientsMap;
        this.ingredientHelperMap = ingredientHelperMap;
        this.ingredientRendererMap = ingredientRendererMap;
        for (ItemStack itemStack : this.getIngredients(ItemStack.class)) {
            this.getStackProperties(itemStack);
        }
    }

    private void getStackProperties(ItemStack itemStack) {
        String itemStackInfo;
        try {
            if (TileEntityFurnace.func_145954_b((ItemStack)itemStack)) {
                this.fuels.add(itemStack);
            }
        }
        catch (RuntimeException e) {
            itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            Log.error("Failed to check if item is fuel {}.", itemStackInfo, e);
        }
        catch (LinkageError e) {
            itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            Log.error("Failed to check if item is fuel {}.", itemStackInfo, e);
        }
        try {
            if (PotionHelper.func_185205_a((ItemStack)itemStack)) {
                this.potionIngredients.add(itemStack);
            }
        }
        catch (RuntimeException e) {
            itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            Log.error("Failed to check if item is a potion ingredient {}.", itemStackInfo, e);
        }
        catch (LinkageError e) {
            itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            Log.error("Failed to check if item is a potion ingredient {}.", itemStackInfo, e);
        }
    }

    @Override
    public <V> List<V> getIngredients(Class<V> ingredientClass) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        List ingredients = this.ingredientsMap.get(ingredientClass);
        if (ingredients == null) {
            return ImmutableList.of();
        }
        return Collections.unmodifiableList(ingredients);
    }

    public boolean isKnownIngredientType(Object ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        return this.ingredientHelperMap.get(ingredient.getClass()) != null;
    }

    @Override
    public <V> IIngredientHelper<V> getIngredientHelper(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        return this.getIngredientHelper(ingredient.getClass());
    }

    @Override
    public <V> IIngredientHelper<V> getIngredientHelper(Class<? extends V> ingredientClass) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        IIngredientHelper ingredientHelper = (IIngredientHelper)this.ingredientHelperMap.get(ingredientClass);
        if (ingredientHelper == null) {
            throw new IllegalArgumentException("Unknown ingredient type: " + ingredientClass);
        }
        return ingredientHelper;
    }

    @Override
    public <V> IIngredientRenderer<V> getIngredientRenderer(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        Class<?> ingredientClass = ingredient.getClass();
        return this.getIngredientRenderer(ingredientClass);
    }

    @Override
    public <V> IIngredientRenderer<V> getIngredientRenderer(Class<? extends V> ingredientClass) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        IIngredientRenderer ingredientRenderer = (IIngredientRenderer)this.ingredientRendererMap.get(ingredientClass);
        if (ingredientRenderer == null) {
            throw new IllegalArgumentException("Could not find ingredient renderer for " + ingredientClass);
        }
        return ingredientRenderer;
    }

    @Override
    public Collection<Class> getRegisteredIngredientClasses() {
        return Collections.unmodifiableCollection(this.ingredientsMap.keySet());
    }

    @Override
    public List<ItemStack> getFuels() {
        return Collections.unmodifiableList(this.fuels);
    }

    @Override
    public List<ItemStack> getPotionIngredients() {
        return Collections.unmodifiableList(this.potionIngredients);
    }

    @Override
    public <V> void addIngredientsAtRuntime(Class<V> ingredientClass, List<V> ingredients) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        ArrayList<V> list = this.ingredientsMap.get(ingredientClass);
        if (list == null) {
            list = new ArrayList<V>();
            this.ingredientsMap.put(ingredientClass, list);
        }
        list.addAll(ingredients);
        List<IIngredientListElement> ingredientListElements = IngredientListElementFactory.createList(this, ingredientClass, ingredients, ForgeModIdHelper.getInstance());
        Internal.getIngredientFilter().addIngredients(ingredientListElements);
    }

    @Override
    public <V> void removeIngredientsAtRuntime(Class<V> ingredientClass, List<V> ingredients) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        List list = this.ingredientsMap.get(ingredientClass);
        if (list != null) {
            list.removeAll(ingredients);
        }
        List<IIngredientListElement> ingredientListElements = IngredientListElementFactory.createList(this, ingredientClass, ingredients, ForgeModIdHelper.getInstance());
        Internal.getIngredientFilter().removeIngredients(ingredientListElements);
    }
}

