/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.awt.Rectangle;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.JustEnoughItems;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.config.Config;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IPaged;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.network.packets.PacketDeletePlayerItem;
import mezz.jei.render.GuiIngredientFast;
import mezz.jei.render.GuiIngredientFastList;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.startup.StackHelper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public abstract class IngredientGrid
implements IShowsRecipeFocuses,
IPaged {
    private static final int INGREDIENT_PADDING = 1;
    private static final int INGREDIENT_WIDTH = GuiItemStackGroup.getWidth(1);
    private static final int INGREDIENT_HEIGHT = GuiItemStackGroup.getHeight(1);
    private Set<Rectangle> guiAreas = Collections.emptySet();
    private Rectangle area = new Rectangle();
    protected final GuiIngredientFastList guiIngredientList;
    @Nullable
    private GuiIngredientFast hovered;

    public IngredientGrid(IIngredientRegistry ingredientRegistry) {
        this.guiIngredientList = new GuiIngredientFastList(ingredientRegistry);
    }

    private static boolean intersects(Collection<Rectangle> areas, Rectangle comparisonArea) {
        for (Rectangle area : areas) {
            if (!area.intersects(comparisonArea)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMouseOverGuiArea(Collection<Rectangle> guiAreas, int mouseX, int mouseY) {
        for (Rectangle guiArea : guiAreas) {
            if (!guiArea.contains(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    private static Set<Rectangle> getGuiAreas() {
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (currentScreen instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)currentScreen;
            JeiRuntime jeiRuntime = Internal.getRuntime();
            if (jeiRuntime != null) {
                HashSet<Rectangle> allGuiExtraAreas = new HashSet<Rectangle>();
                List<IAdvancedGuiHandler<GuiContainer>> activeAdvancedGuiHandlers = jeiRuntime.getActiveAdvancedGuiHandlers(guiContainer);
                for (IAdvancedGuiHandler<GuiContainer> advancedGuiHandler : activeAdvancedGuiHandlers) {
                    List<Rectangle> guiExtraAreas = advancedGuiHandler.getGuiExtraAreas(guiContainer);
                    if (guiExtraAreas == null) continue;
                    allGuiExtraAreas.addAll(guiExtraAreas);
                }
                return allGuiExtraAreas;
            }
        }
        return Collections.emptySet();
    }

    public void updateBounds(Rectangle area) {
        int columns = area.width / INGREDIENT_WIDTH;
        int rows = area.height / INGREDIENT_HEIGHT;
        int width = columns * INGREDIENT_WIDTH;
        int height = rows * INGREDIENT_HEIGHT;
        int x = area.x + (area.width - width) / 2;
        int y = area.y + (area.height - height) / 2;
        this.area = new Rectangle(x, y, width, height);
        this.guiIngredientList.clear();
        this.guiAreas = IngredientGrid.getGuiAreas();
        for (int row = 0; row < rows; ++row) {
            int y1 = y + row * INGREDIENT_HEIGHT;
            for (int column = 0; column < columns; ++column) {
                int x1 = x + column * INGREDIENT_WIDTH;
                GuiIngredientFast guiIngredientFast = new GuiIngredientFast(x1, y1, 1);
                Rectangle stackArea = guiIngredientFast.getArea();
                boolean blocked = IngredientGrid.intersects(this.guiAreas, stackArea);
                guiIngredientFast.setBlocked(blocked);
                this.guiIngredientList.add(guiIngredientFast);
            }
        }
    }

    public void updateLayout() {
        for (GuiIngredientFast guiIngredientFast : this.guiIngredientList.getAllGuiIngredients()) {
            Rectangle stackArea = guiIngredientFast.getArea();
            boolean blocked = IngredientGrid.intersects(this.guiAreas, stackArea);
            guiIngredientFast.setBlocked(blocked);
        }
    }

    public Rectangle getArea() {
        return this.area;
    }

    public void draw(Minecraft minecraft, int mouseX, int mouseY) {
        GlStateManager.func_179084_k();
        if (IngredientGrid.shouldShowDeleteItemTooltip(minecraft)) {
            this.hovered = this.guiIngredientList.render(minecraft, false, mouseX, mouseY);
        } else {
            boolean mouseOver = this.isMouseOver(mouseX, mouseY);
            this.hovered = this.guiIngredientList.render(minecraft, mouseOver, mouseX, mouseY);
        }
        this.drawHighlightedIngredients();
        if (this.hovered != null) {
            this.hovered.drawHovered(minecraft);
        }
        GlStateManager.func_179141_d();
    }

    private void drawHighlightedIngredients() {
        JeiRuntime runtime = Internal.getRuntime();
        if (runtime == null) {
            return;
        }
        NonNullList<ItemStack> highlightedStacks = runtime.getItemListOverlay().getHighlightedStacks();
        if (highlightedStacks.isEmpty()) {
            return;
        }
        StackHelper helper = Internal.getHelpers().getStackHelper();
        for (GuiIngredientFast guiItemStack : this.guiIngredientList.getAllGuiIngredients()) {
            Object ingredient;
            IIngredientListElement element = guiItemStack.getElement();
            if (element == null || !((ingredient = element.getIngredient()) instanceof ItemStack) || helper.containsStack((Iterable<ItemStack>)highlightedStacks, (ItemStack)ingredient) == null) continue;
            guiItemStack.drawHighlight();
        }
    }

    public void drawTooltips(Minecraft minecraft, int mouseX, int mouseY) {
        boolean mouseOver = this.isMouseOver(mouseX, mouseY);
        if (mouseOver && IngredientGrid.shouldShowDeleteItemTooltip(minecraft)) {
            String deleteItem = Translator.translateToLocal("jei.tooltip.delete.item");
            TooltipRenderer.drawHoveringText(minecraft, deleteItem, mouseX, mouseY);
        }
        if (this.hovered != null) {
            this.hovered.drawTooltip(minecraft, mouseX, mouseY);
        }
    }

    private static boolean shouldShowDeleteItemTooltip(Minecraft minecraft) {
        if (Config.isDeleteItemsInCheatModeActive()) {
            EntityPlayerSP player = minecraft.field_71439_g;
            if (!player.field_71071_by.func_70445_o().func_190926_b()) {
                JeiRuntime runtime = Internal.getRuntime();
                return runtime == null || !runtime.getRecipesGui().isOpen();
            }
        }
        return false;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.area.contains(mouseX, mouseY) && !IngredientGrid.isMouseOverGuiArea(this.guiAreas, mouseX, mouseY);
    }

    public boolean handleMouseClicked(int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            Minecraft minecraft = Minecraft.func_71410_x();
            JeiRuntime runtime = Internal.getRuntime();
            if (Config.isDeleteItemsInCheatModeActive() && (runtime == null || !runtime.getRecipesGui().isOpen())) {
                EntityPlayerSP player = minecraft.field_71439_g;
                ItemStack itemStack = player.field_71071_by.func_70445_o();
                if (!itemStack.func_190926_b()) {
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                    PacketDeletePlayerItem packet = new PacketDeletePlayerItem(itemStack);
                    JustEnoughItems.getProxy().sendPacketToServer(packet);
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public IIngredientListElement getElementUnderMouse() {
        IIngredientListElement element;
        if (this.hovered != null && (element = this.hovered.getElement()) != null) {
            return element;
        }
        return null;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            ClickedIngredient<?> clicked = this.guiIngredientList.getIngredientUnderMouse(mouseX, mouseY);
            if (clicked != null) {
                clicked.setAllowsCheating();
            }
            return clicked;
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return true;
    }

    public boolean updateGuiAreas() {
        Set<Rectangle> guiAreas = IngredientGrid.getGuiAreas();
        if (!guiAreas.equals(this.guiAreas)) {
            this.guiAreas = guiAreas;
            return true;
        }
        return false;
    }

    public abstract int getPageCount();

    public abstract int getPageNum();

    public abstract List<IIngredientListElement> getVisibleElements();
}

