/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.gui.ingredients.GuiIngredient;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;

public class GuiIngredientGroup<T>
implements IGuiIngredientGroup<T> {
    private final int itemCycleOffset = (int)(Math.random() * 1000.0);
    private final Map<Integer, GuiIngredient<T>> guiIngredients = new HashMap<Integer, GuiIngredient<T>>();
    private final Set<Integer> inputSlots = new HashSet<Integer>();
    private final IIngredientHelper<T> ingredientHelper;
    private final Class<T> ingredientClass;
    private final IFocus<T> focus;
    @Nullable
    private ITooltipCallback<T> tooltipCallback;

    public GuiIngredientGroup(Class<T> ingredientClass, IFocus<T> focus) {
        this.ingredientClass = ingredientClass;
        this.focus = focus;
        this.ingredientHelper = Internal.getIngredientRegistry().getIngredientHelper(ingredientClass);
    }

    @Override
    public void init(int slotIndex, boolean input, IIngredientRenderer<T> ingredientRenderer, int xPosition, int yPosition, int width, int height, int xPadding, int yPadding) {
        GuiIngredient<T> guiIngredient = new GuiIngredient<T>(slotIndex, input, ingredientRenderer, this.ingredientHelper, xPosition, yPosition, width, height, xPadding, yPadding, this.itemCycleOffset);
        this.guiIngredients.put(slotIndex, guiIngredient);
        if (input) {
            this.inputSlots.add(slotIndex);
        }
    }

    @Override
    public IFocus<T> getFocus() {
        return this.focus;
    }

    @Override
    public void set(IIngredients ingredients) {
        List<List<T>> inputs = ingredients.getInputs(this.ingredientClass);
        List<T> outputs = ingredients.getOutputs(this.ingredientClass);
        int inputIndex = 0;
        int outputIndex = 0;
        ArrayList<Integer> slots = new ArrayList<Integer>(this.guiIngredients.keySet());
        Collections.sort(slots);
        for (Integer slot : slots) {
            if (this.inputSlots.contains(slot)) {
                if (inputIndex >= inputs.size()) continue;
                List<T> input = inputs.get(inputIndex);
                ++inputIndex;
                this.set((int)slot, (T)input);
                continue;
            }
            if (outputIndex >= outputs.size()) continue;
            T output = outputs.get(outputIndex);
            ++outputIndex;
            this.set((int)slot, output);
        }
    }

    @Override
    @Deprecated
    public void set(int slotIndex, Collection<T> values) {
        this.set(slotIndex, (T)new ArrayList<T>(values));
    }

    @Override
    public void set(int slotIndex, @Nullable List<T> ingredients) {
        if (ingredients != null) {
            for (T ingredient : ingredients) {
                if (this.ingredientClass.isInstance(ingredient) || ingredient == null) continue;
                Log.error("Received wrong type of ingredient. Expected {}, got {}", this.ingredientClass, ingredient.getClass(), new IllegalArgumentException());
                return;
            }
        }
        this.guiIngredients.get(slotIndex).set(ingredients, this.focus);
    }

    @Override
    public void set(int slotIndex, @Nullable T value) {
        this.set(slotIndex, (T)Collections.singletonList(value));
    }

    @Override
    public void addTooltipCallback(ITooltipCallback<T> tooltipCallback) {
        this.tooltipCallback = tooltipCallback;
    }

    @Override
    public Map<Integer, GuiIngredient<T>> getGuiIngredients() {
        return this.guiIngredients;
    }

    @Nullable
    public T getIngredientUnderMouse(int xOffset, int yOffset, int mouseX, int mouseY) {
        for (GuiIngredient<T> guiIngredient : this.guiIngredients.values()) {
            T displayedIngredient;
            if (guiIngredient == null || !guiIngredient.isMouseOver(xOffset, yOffset, mouseX, mouseY) || (displayedIngredient = guiIngredient.getDisplayedIngredient()) == null) continue;
            return displayedIngredient;
        }
        return null;
    }

    @Nullable
    public GuiIngredient<T> draw(Minecraft minecraft, int xOffset, int yOffset, int mouseX, int mouseY) {
        GuiIngredient<T> hovered = null;
        for (GuiIngredient<T> ingredient : this.guiIngredients.values()) {
            if (hovered == null && ingredient.isMouseOver(xOffset, yOffset, mouseX, mouseY)) {
                hovered = ingredient;
                hovered.setTooltipCallback(this.tooltipCallback);
                continue;
            }
            ingredient.draw(minecraft, xOffset, yOffset);
        }
        return hovered;
    }
}

