/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.InternalRecipeRegistryPlugin;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.config.Config;
import mezz.jei.gui.Focus;
import mezz.jei.gui.recipes.RecipeClickableArea;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.IngredientUtil;
import mezz.jei.util.Ingredients;
import mezz.jei.util.Log;
import mezz.jei.util.RecipeCategoryComparator;
import mezz.jei.util.RecipeMap;
import mezz.jei.util.StackHelper;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.ProgressManager;

public class RecipeRegistry
implements IRecipeRegistry {
    private final StackHelper stackHelper;
    private final IIngredientRegistry ingredientRegistry;
    private final List<IRecipeHandler> recipeHandlers;
    private final ImmutableTable<Class, String, IRecipeTransferHandler> recipeTransferHandlers;
    private final ImmutableMultimap<Class<? extends GuiContainer>, RecipeClickableArea> recipeClickableAreasMap;
    private final ImmutableListMultimap<IRecipeCategory, ItemStack> craftItemsForCategories;
    private final ImmutableMultimap<String, String> categoriesForCraftItemKeys;
    private final ImmutableMap<String, IRecipeCategory> recipeCategoriesMap;
    private final ListMultimap<IRecipeCategory, Object> recipesForCategories = ArrayListMultimap.create();
    private final ListMultimap<IRecipeCategory, IRecipeWrapper> recipeWrappersForCategories = ArrayListMultimap.create();
    private final RecipeMap recipeInputMap;
    private final RecipeMap recipeOutputMap;
    private final Set<Class> unhandledRecipeClasses = new HashSet<Class>();
    private final List<IRecipeRegistryPlugin> plugins = new ArrayList<IRecipeRegistryPlugin>();

    public RecipeRegistry(StackHelper stackHelper, List<IRecipeCategory> recipeCategories, List<IRecipeHandler> recipeHandlers, ImmutableTable<Class, String, IRecipeTransferHandler> recipeTransferHandlers, List<Object> recipes, Multimap<Class<? extends GuiContainer>, RecipeClickableArea> recipeClickableAreasMap, Multimap<String, ItemStack> craftItemsForCategories, IIngredientRegistry ingredientRegistry, List<IRecipeRegistryPlugin> plugins) {
        this.stackHelper = stackHelper;
        this.ingredientRegistry = ingredientRegistry;
        this.recipeCategoriesMap = RecipeRegistry.buildRecipeCategoriesMap(recipeCategories);
        this.recipeTransferHandlers = recipeTransferHandlers;
        this.recipeHandlers = RecipeRegistry.buildRecipeHandlersList(recipeHandlers);
        this.recipeClickableAreasMap = ImmutableMultimap.copyOf(recipeClickableAreasMap);
        RecipeCategoryComparator recipeCategoryComparator = new RecipeCategoryComparator(recipeCategories);
        this.recipeInputMap = new RecipeMap(recipeCategoryComparator, ingredientRegistry);
        this.recipeOutputMap = new RecipeMap(recipeCategoryComparator, ingredientRegistry);
        this.addRecipes(recipes);
        ImmutableListMultimap.Builder craftItemsForCategoriesBuilder = ImmutableListMultimap.builder();
        ImmutableMultimap.Builder categoriesForCraftItemKeysBuilder = ImmutableMultimap.builder();
        IIngredientHelper<ItemStack> ingredientHelper = ingredientRegistry.getIngredientHelper(ItemStack.class);
        for (Map.Entry recipeCategoryEntry : craftItemsForCategories.asMap().entrySet()) {
            String recipeCategoryUid = (String)recipeCategoryEntry.getKey();
            IRecipeCategory recipeCategory = (IRecipeCategory)this.recipeCategoriesMap.get((Object)recipeCategoryUid);
            if (recipeCategory == null) continue;
            Collection craftItems = (Collection)recipeCategoryEntry.getValue();
            craftItemsForCategoriesBuilder.putAll((Object)recipeCategory, (Iterable)craftItems);
            for (ItemStack craftItem : craftItems) {
                this.recipeInputMap.addRecipeCategory(recipeCategory, craftItem);
                String craftItemKey = ingredientHelper.getUniqueId(craftItem);
                categoriesForCraftItemKeysBuilder.put((Object)craftItemKey, (Object)recipeCategoryUid);
            }
        }
        this.craftItemsForCategories = craftItemsForCategoriesBuilder.build();
        this.categoriesForCraftItemKeys = categoriesForCraftItemKeysBuilder.build();
        InternalRecipeRegistryPlugin internalRecipeRegistryPlugin = new InternalRecipeRegistryPlugin(this, this.categoriesForCraftItemKeys, ingredientRegistry, this.recipeCategoriesMap, this.recipeInputMap, this.recipeOutputMap, this.recipeWrappersForCategories);
        this.plugins.add(internalRecipeRegistryPlugin);
        this.plugins.addAll(plugins);
    }

    private static ImmutableMap<String, IRecipeCategory> buildRecipeCategoriesMap(List<IRecipeCategory> recipeCategories) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (IRecipeCategory recipeCategory : recipeCategories) {
            mapBuilder.put((Object)recipeCategory.getUid(), (Object)recipeCategory);
        }
        return mapBuilder.build();
    }

    private static ImmutableList<IRecipeHandler> buildRecipeHandlersList(List<IRecipeHandler> recipeHandlers) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        HashSet recipeHandlerClasses = new HashSet();
        for (IRecipeHandler recipeHandler : recipeHandlers) {
            Class recipeClass;
            if (recipeHandler == null) continue;
            try {
                recipeClass = recipeHandler.getRecipeClass();
            }
            catch (RuntimeException e) {
                Log.error("Recipe handler crashed.", e);
                continue;
            }
            catch (LinkageError e) {
                Log.error("Recipe handler crashed.", e);
                continue;
            }
            if (recipeHandlerClasses.contains(recipeClass)) {
                Log.error("A Recipe Handler has already been registered for this recipe class: " + recipeClass.getName(), new Object[0]);
                continue;
            }
            recipeHandlerClasses.add(recipeClass);
            listBuilder.add((Object)recipeHandler);
        }
        return listBuilder.build();
    }

    private void addRecipes(@Nullable List<Object> recipes) {
        if (recipes == null) {
            return;
        }
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Adding recipes", (int)recipes.size());
        for (Object recipe : recipes) {
            progressBar.step("");
            this.addRecipe(recipe);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    @Override
    public <V> IFocus<V> createFocus(IFocus.Mode mode, @Nullable V ingredient) {
        return new Focus<V>(mode, ingredient);
    }

    @Override
    public void addRecipe(@Nullable Object recipe) {
        if (recipe == null) {
            Log.error("Null recipe", new NullPointerException());
            return;
        }
        this.addRecipe(recipe, recipe.getClass());
    }

    private <T> void addRecipe(T recipe, Class<? extends T> recipeClass) {
        String recipeCategoryUid;
        IRecipeHandler<T> recipeHandler = this.getRecipeHandler(recipeClass);
        if (recipeHandler == null) {
            if (!this.unhandledRecipeClasses.contains(recipeClass)) {
                this.unhandledRecipeClasses.add(recipeClass);
                if (Config.isDebugModeEnabled()) {
                    Log.debug("Can't handle recipe: {}", recipeClass);
                }
            }
            return;
        }
        try {
            recipeCategoryUid = recipeHandler.getRecipeCategoryUid(recipe);
        }
        catch (AbstractMethodError ignored) {
            recipeCategoryUid = recipeHandler.getRecipeCategoryUid();
        }
        IRecipeCategory recipeCategory = (IRecipeCategory)this.recipeCategoriesMap.get((Object)recipeCategoryUid);
        if (recipeCategory == null) {
            Log.error("No recipe category registered for recipeCategoryUid: {}", recipeCategoryUid);
            return;
        }
        if (!recipeHandler.isRecipeValid(recipe)) {
            return;
        }
        try {
            this.addRecipeUnchecked(recipe, recipeCategory, recipeHandler);
        }
        catch (RuntimeException e) {
            String recipeInfo = ErrorUtil.getInfoFromBrokenRecipe(recipe, recipeHandler);
            String errorMessage = e.getMessage();
            if ("Found an itemStack with a null item. This is an error from another mod.".equals(errorMessage)) {
                Log.error("Found a broken recipe: {}\n", recipeInfo);
            } else {
                Log.error("Found a broken recipe: {}\n", recipeInfo, e);
            }
        }
        catch (LinkageError e) {
            String recipeInfo = ErrorUtil.getInfoFromBrokenRecipe(recipe, recipeHandler);
            String errorMessage = e.getMessage();
            if ("Found an itemStack with a null item. This is an error from another mod.".equals(errorMessage)) {
                Log.error("Found a broken recipe: {}\n", recipeInfo);
            }
            Log.error("Found a broken recipe: {}\n", recipeInfo, e);
        }
    }

    private <T> void addRecipeUnchecked(T recipe, IRecipeCategory recipeCategory, IRecipeHandler<T> recipeHandler) {
        IRecipeWrapper recipeWrapper = recipeHandler.getRecipeWrapper(recipe);
        Ingredients ingredients = new Ingredients();
        try {
            recipeWrapper.getIngredients(ingredients);
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
        if (ingredients.isUsed()) {
            this.recipeInputMap.addRecipe(recipe, recipeCategory, recipeHandler, ingredients.getInputIngredients());
            this.recipeOutputMap.addRecipe(recipe, recipeCategory, recipeHandler, ingredients.getOutputIngredients());
        } else {
            this.legacy_addRecipeUnchecked(recipeWrapper, recipe, recipeHandler, recipeCategory);
        }
        this.recipesForCategories.put((Object)recipeCategory, recipe);
        this.recipeWrappersForCategories.put((Object)recipeCategory, (Object)recipeWrapper);
    }

    private <T> void legacy_addRecipeUnchecked(IRecipeWrapper recipeWrapper, T recipe, IRecipeHandler<T> recipeHandler, IRecipeCategory recipeCategory) {
        List inputs = recipeWrapper.getInputs();
        List<Object> fluidInputs = recipeWrapper.getFluidInputs();
        if (inputs != null || fluidInputs != null) {
            List<ItemStack> inputStacks = this.stackHelper.toItemStackList(inputs);
            if (fluidInputs == null) {
                fluidInputs = Collections.emptyList();
            }
            HashMap<Class, List> inputIngredients = new HashMap<Class, List>();
            inputIngredients.put(ItemStack.class, inputStacks);
            inputIngredients.put(FluidStack.class, fluidInputs);
            this.recipeInputMap.addRecipe(recipe, recipeCategory, recipeHandler, inputIngredients);
        }
        List outputs = recipeWrapper.getOutputs();
        List<Object> fluidOutputs = recipeWrapper.getFluidOutputs();
        if (outputs != null || fluidOutputs != null) {
            List<ItemStack> outputStacks = this.stackHelper.toItemStackList(outputs);
            if (fluidOutputs == null) {
                fluidOutputs = Collections.emptyList();
            }
            HashMap<Class, List> outputIngredients = new HashMap<Class, List>();
            outputIngredients.put(ItemStack.class, outputStacks);
            outputIngredients.put(FluidStack.class, fluidOutputs);
            this.recipeOutputMap.addRecipe(recipe, recipeCategory, recipeHandler, outputIngredients);
        }
    }

    @Override
    public List<IRecipeCategory> getRecipeCategories() {
        return new ArrayList<IRecipeCategory>((Collection<IRecipeCategory>)this.recipeCategoriesMap.values());
    }

    public ImmutableList<IRecipeCategory> getRecipeCategories(@Nullable List<String> recipeCategoryUids) {
        if (recipeCategoryUids == null) {
            Log.error("Null recipeCategoryUids", new NullPointerException());
            return ImmutableList.of();
        }
        HashSet<String> uniqueUids = new HashSet<String>();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String recipeCategoryUid : recipeCategoryUids) {
            if (uniqueUids.contains(recipeCategoryUid)) continue;
            uniqueUids.add(recipeCategoryUid);
            IRecipeCategory recipeCategory = (IRecipeCategory)this.recipeCategoriesMap.get((Object)recipeCategoryUid);
            if (recipeCategory == null || this.getRecipeWrappers(recipeCategory).isEmpty()) continue;
            builder.add((Object)recipeCategory);
        }
        return builder.build();
    }

    @Override
    @Nullable
    public <T> IRecipeHandler<T> getRecipeHandler(@Nullable Class<? extends T> recipeClass) {
        if (recipeClass == null) {
            Log.error("Null recipeClass", new NullPointerException());
            return null;
        }
        for (IRecipeHandler recipeHandler : this.recipeHandlers) {
            if (!recipeHandler.getRecipeClass().equals(recipeClass)) continue;
            return recipeHandler;
        }
        for (IRecipeHandler recipeHandler : this.recipeHandlers) {
            if (!recipeHandler.getRecipeClass().isAssignableFrom(recipeClass)) continue;
            return recipeHandler;
        }
        return null;
    }

    @Nullable
    public RecipeClickableArea getRecipeClickableArea(GuiContainer gui, int mouseX, int mouseY) {
        ImmutableCollection recipeClickableAreas = this.recipeClickableAreasMap.get(gui.getClass());
        for (RecipeClickableArea recipeClickableArea : recipeClickableAreas) {
            if (!recipeClickableArea.checkHover(mouseX, mouseY)) continue;
            return recipeClickableArea;
        }
        return null;
    }

    @Nullable
    private static FluidStack getFluidFromItemBlock(IFocus<?> focus) {
        Block block;
        Fluid fluid;
        ItemStack itemStack;
        Item item;
        if (focus.getMode() == IFocus.Mode.NONE) {
            return null;
        }
        Object ingredient = focus.getValue();
        if (ingredient instanceof ItemStack && (item = (itemStack = (ItemStack)ingredient).func_77973_b()) instanceof ItemBlock && (fluid = FluidRegistry.lookupFluidForBlock((Block)(block = ((ItemBlock)item).func_179223_d()))) != null) {
            return new FluidStack(fluid, 1000);
        }
        return null;
    }

    @Override
    public <V> List<IRecipeCategory> getRecipeCategories(@Nullable IFocus<V> focus) {
        if (focus == null) {
            Log.error("Null focus", new NullPointerException());
            return ImmutableList.of();
        }
        FluidStack fluidStack = RecipeRegistry.getFluidFromItemBlock(focus);
        if (fluidStack != null) {
            return this.getRecipeCategories(this.createFocus(focus.getMode(), fluidStack));
        }
        ArrayList<String> allRecipeCategoryUids = new ArrayList<String>();
        for (IRecipeRegistryPlugin plugin : this.plugins) {
            long start_time = System.currentTimeMillis();
            List<String> recipeCategoryUids = plugin.getRecipeCategoryUids(focus);
            long timeElapsed = System.currentTimeMillis() - start_time;
            if (timeElapsed > 10L) {
                Log.warning("Recipe Category lookup is slow: {} ms. {}", timeElapsed, plugin.getClass());
            }
            allRecipeCategoryUids.addAll(recipeCategoryUids);
        }
        return this.getRecipeCategories(allRecipeCategoryUids);
    }

    @Override
    @Deprecated
    public <V> List<Object> getRecipes(@Nullable IRecipeCategory recipeCategory, @Nullable IFocus<V> focus) {
        if (recipeCategory == null) {
            Log.error("Null recipeCategory", new NullPointerException());
            return ImmutableList.of();
        }
        if (focus == null) {
            Log.error("Null focus", new NullPointerException());
            return ImmutableList.of();
        }
        if (focus.getMode() == IFocus.Mode.NONE) {
            return this.getRecipes(recipeCategory);
        }
        V ingredient = focus.getValue();
        if (ingredient == null) {
            Log.error("Null ingredient", new NullPointerException());
            return ImmutableList.of();
        }
        FluidStack fluidStack = RecipeRegistry.getFluidFromItemBlock(focus);
        if (fluidStack != null) {
            return this.getRecipes(recipeCategory, this.createFocus(focus.getMode(), fluidStack));
        }
        IIngredientHelper<V> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredient);
        if (focus.getMode() == IFocus.Mode.INPUT) {
            ImmutableList<Object> recipes = this.recipeInputMap.getRecipes(recipeCategory, ingredient);
            String recipeCategoryUid = recipeCategory.getUid();
            for (String inputKey : IngredientUtil.getUniqueIdsWithWildcard(ingredientHelper, ingredient)) {
                if (!this.categoriesForCraftItemKeys.get((Object)inputKey).contains((Object)recipeCategoryUid)) continue;
                ImmutableSet specificRecipes = ImmutableSet.copyOf(recipes);
                List recipesForCategory = this.recipesForCategories.get((Object)recipeCategory);
                ArrayList<Object> allRecipes = new ArrayList<Object>((Collection<Object>)recipes);
                for (Object recipe : recipesForCategory) {
                    if (specificRecipes.contains(recipe)) continue;
                    allRecipes.add(recipe);
                }
                return allRecipes;
            }
            return recipes;
        }
        if (focus.getMode() == IFocus.Mode.OUTPUT) {
            return this.recipeOutputMap.getRecipes(recipeCategory, ingredient);
        }
        return this.getRecipes(recipeCategory);
    }

    @Override
    public <T extends IRecipeWrapper, V> List<T> getRecipeWrappers(@Nullable IRecipeCategory<T> recipeCategory, @Nullable IFocus<V> focus) {
        if (recipeCategory == null) {
            Log.error("Null recipeCategory", new NullPointerException());
            return ImmutableList.of();
        }
        if (focus == null) {
            Log.error("Null focus", new NullPointerException());
            return ImmutableList.of();
        }
        FluidStack fluidStack = RecipeRegistry.getFluidFromItemBlock(focus);
        if (fluidStack != null) {
            return this.getRecipeWrappers(recipeCategory, this.createFocus(focus.getMode(), fluidStack));
        }
        ArrayList<T> allRecipeWrappers = new ArrayList<T>();
        for (IRecipeRegistryPlugin plugin : this.plugins) {
            long start_time = System.currentTimeMillis();
            List<T> recipeWrappers = plugin.getRecipeWrappers(recipeCategory, focus);
            long timeElapsed = System.currentTimeMillis() - start_time;
            if (timeElapsed > 10L) {
                Log.warning("Recipe Wrapper lookup is slow: {} ms. {}", timeElapsed, plugin.getClass());
            }
            allRecipeWrappers.addAll(recipeWrappers);
        }
        return allRecipeWrappers;
    }

    @Override
    public <T extends IRecipeWrapper> List<T> getRecipeWrappers(@Nullable IRecipeCategory<T> recipeCategory) {
        return this.getRecipeWrappers(recipeCategory, this.createFocus(IFocus.Mode.NONE, null));
    }

    @Override
    @Deprecated
    public List<IRecipeCategory> getRecipeCategoriesWithInput(@Nullable ItemStack input) {
        return this.getRecipeCategories(new Focus<ItemStack>(IFocus.Mode.INPUT, input));
    }

    @Override
    @Deprecated
    public List<IRecipeCategory> getRecipeCategoriesWithInput(@Nullable FluidStack input) {
        return this.getRecipeCategories(new Focus<FluidStack>(IFocus.Mode.INPUT, input));
    }

    @Override
    @Deprecated
    public List<IRecipeCategory> getRecipeCategoriesWithOutput(@Nullable ItemStack output) {
        return this.getRecipeCategories(new Focus<ItemStack>(IFocus.Mode.OUTPUT, output));
    }

    @Override
    @Deprecated
    public List<IRecipeCategory> getRecipeCategoriesWithOutput(@Nullable FluidStack output) {
        return this.getRecipeCategories(new Focus<FluidStack>(IFocus.Mode.OUTPUT, output));
    }

    @Override
    @Deprecated
    public List<Object> getRecipesWithInput(@Nullable IRecipeCategory recipeCategory, @Nullable ItemStack input) {
        return this.getRecipes(recipeCategory, new Focus<ItemStack>(IFocus.Mode.INPUT, input));
    }

    @Override
    @Deprecated
    public List<Object> getRecipesWithInput(@Nullable IRecipeCategory recipeCategory, @Nullable FluidStack input) {
        return this.getRecipes(recipeCategory, new Focus<FluidStack>(IFocus.Mode.INPUT, input));
    }

    @Override
    @Deprecated
    public List<Object> getRecipesWithOutput(@Nullable IRecipeCategory recipeCategory, @Nullable ItemStack output) {
        return this.getRecipes(recipeCategory, new Focus<ItemStack>(IFocus.Mode.OUTPUT, output));
    }

    @Override
    @Deprecated
    public List<Object> getRecipesWithOutput(@Nullable IRecipeCategory recipeCategory, @Nullable FluidStack output) {
        return this.getRecipes(recipeCategory, new Focus<FluidStack>(IFocus.Mode.OUTPUT, output));
    }

    @Override
    @Deprecated
    public List<Object> getRecipes(@Nullable IRecipeCategory recipeCategory) {
        if (recipeCategory == null) {
            Log.error("Null recipeCategory", new NullPointerException());
            return ImmutableList.of();
        }
        return Collections.unmodifiableList(this.recipesForCategories.get((Object)recipeCategory));
    }

    @Deprecated
    public ImmutableCollection<ItemStack> getCraftingItems(IRecipeCategory recipeCategory) {
        return this.craftItemsForCategories.get((Object)recipeCategory);
    }

    @Override
    public List<ItemStack> getCraftingItems(IRecipeCategory recipeCategory, IFocus focus) {
        ImmutableList craftingItems = this.craftItemsForCategories.get((Object)recipeCategory);
        Object ingredient = focus.getValue();
        if (ingredient instanceof ItemStack && focus.getMode() == IFocus.Mode.INPUT) {
            ItemStack itemStack = (ItemStack)ingredient;
            IIngredientHelper<ItemStack> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ItemStack.class);
            ItemStack matchingStack = ingredientHelper.getMatch((Iterable<ItemStack>)craftingItems, itemStack);
            if (matchingStack != null) {
                return Collections.singletonList(matchingStack);
            }
        }
        return craftingItems;
    }

    @Override
    @Nullable
    public IRecipeTransferHandler getRecipeTransferHandler(@Nullable Container container, @Nullable IRecipeCategory recipeCategory) {
        if (container == null) {
            Log.error("Null container", new NullPointerException());
            return null;
        }
        if (recipeCategory == null) {
            Log.error("Null recipeCategory", new NullPointerException());
            return null;
        }
        Class<?> containerClass = container.getClass();
        IRecipeTransferHandler recipeTransferHandler = (IRecipeTransferHandler)this.recipeTransferHandlers.get(containerClass, (Object)recipeCategory.getUid());
        if (recipeTransferHandler != null) {
            return recipeTransferHandler;
        }
        return (IRecipeTransferHandler)this.recipeTransferHandlers.get(containerClass, (Object)"universal recipe transfer handler");
    }

    @Override
    @Nullable
    public <T extends IRecipeWrapper> IRecipeLayoutDrawable createRecipeLayoutDrawable(IRecipeCategory<T> recipeCategory, T recipeWrapper, IFocus focus) {
        return new RecipeLayout(-1, recipeCategory, recipeWrapper, focus);
    }
}

