/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.Weigher;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.IngredientBaseListFactory;
import mezz.jei.config.Config;
import mezz.jei.gui.ingredients.IIngredientListElement;
import net.minecraft.item.ItemStack;

public class ItemFilter {
    private final LoadingCache<String, ImmutableList<IIngredientListElement>> filteredItemMapsCache = CacheBuilder.newBuilder().maximumWeight(16L).weigher((Weigher)new OneWeigher()).concurrencyLevel(1).build((CacheLoader)new ItemFilterCacheLoader());
    private ImmutableList<IIngredientListElement> baseList;
    private ImmutableList<ItemStack> itemStacksCached = ImmutableList.of();
    @Nullable
    private String filterCached;

    public ItemFilter(boolean showProgressBar) {
        this.baseList = IngredientBaseListFactory.create(showProgressBar);
    }

    public void rebuild() {
        this.baseList = IngredientBaseListFactory.create(false);
        this.filteredItemMapsCache.invalidateAll();
    }

    public ImmutableList<IIngredientListElement> getIngredientList() {
        String[] filters = Config.getFilterText().split("\\|");
        if (filters.length == 1) {
            String filter = filters[0];
            return (ImmutableList)this.filteredItemMapsCache.getUnchecked((Object)filter);
        }
        ImmutableList.Builder ingredientList = ImmutableList.builder();
        for (String filter : filters) {
            List ingredients = (List)this.filteredItemMapsCache.getUnchecked((Object)filter);
            ingredientList.addAll((Iterable)ingredients);
        }
        return ingredientList.build();
    }

    public ImmutableList<ItemStack> getItemStacks() {
        if (!Config.getFilterText().equals(this.filterCached)) {
            ImmutableList.Builder filteredStacks = ImmutableList.builder();
            for (IIngredientListElement element : this.getIngredientList()) {
                Object ingredient = element.getIngredient();
                if (!(ingredient instanceof ItemStack)) continue;
                filteredStacks.add((Object)((ItemStack)ingredient));
            }
            this.itemStacksCached = filteredStacks.build();
            this.filterCached = Config.getFilterText();
        }
        return this.itemStacksCached;
    }

    public int size() {
        return this.getIngredientList().size();
    }

    private static class FilterPredicate
    implements Predicate<IIngredientListElement> {
        private final List<String> searchTokens = new ArrayList<String>();
        private final List<String> modNameTokens = new ArrayList<String>();
        private final List<String> tooltipTokens = new ArrayList<String>();
        private final List<String> oreDictTokens = new ArrayList<String>();
        private final List<String> creativeTabTokens = new ArrayList<String>();
        private final List<String> colorTokens = new ArrayList<String>();

        public FilterPredicate(String filterText) {
            String[] tokens;
            for (String token : tokens = filterText.split(" ")) {
                if (token.isEmpty()) continue;
                if (token.startsWith("@")) {
                    FilterPredicate.addTokenWithoutPrefix(token, this.modNameTokens);
                    continue;
                }
                if (token.startsWith("#")) {
                    FilterPredicate.addTokenWithoutPrefix(token, this.tooltipTokens);
                    continue;
                }
                if (token.startsWith("$")) {
                    FilterPredicate.addTokenWithoutPrefix(token, this.oreDictTokens);
                    continue;
                }
                if (token.startsWith("%")) {
                    FilterPredicate.addTokenWithoutPrefix(token, this.creativeTabTokens);
                    continue;
                }
                if (token.startsWith("^")) {
                    FilterPredicate.addTokenWithoutPrefix(token, this.colorTokens);
                    continue;
                }
                this.searchTokens.add(token);
            }
        }

        private static void addTokenWithoutPrefix(String token, List<String> tokensList) {
            if (token.length() < 2) {
                return;
            }
            String tokenText = token.substring(1);
            tokensList.add(tokenText);
        }

        public boolean apply(@Nullable IIngredientListElement input) {
            return input != null && FilterPredicate.stringContainsTokens(input.getModNameString(), this.modNameTokens) && FilterPredicate.stringContainsTokens(input.getTooltipString(), this.tooltipTokens) && FilterPredicate.stringContainsTokens(input.getOreDictString(), this.oreDictTokens) && FilterPredicate.stringContainsTokens(input.getCreativeTabsString(), this.creativeTabTokens) && FilterPredicate.stringContainsTokens(input.getColorString(), this.colorTokens) && FilterPredicate.stringContainsTokens(input.getSearchString(), this.searchTokens);
        }

        private static boolean stringContainsTokens(String comparisonString, List<String> tokens) {
            for (String token : tokens) {
                if (comparisonString.contains(token)) continue;
                return false;
            }
            return true;
        }
    }

    private class ItemFilterCacheLoader
    extends CacheLoader<String, ImmutableList<IIngredientListElement>> {
        private ItemFilterCacheLoader() {
        }

        public ImmutableList<IIngredientListElement> load(String filterText) throws Exception {
            if (filterText.length() == 0) {
                return ItemFilter.this.baseList;
            }
            String prevFilterText = filterText.substring(0, filterText.length() - 1);
            ImmutableList baseItemSet = (ImmutableList)ItemFilter.this.filteredItemMapsCache.get((Object)prevFilterText);
            FilterPredicate filterPredicate = new FilterPredicate(filterText);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (IIngredientListElement itemStackElement : baseItemSet) {
                if (!filterPredicate.apply(itemStackElement)) continue;
                builder.add((Object)itemStackElement);
            }
            return builder.build();
        }
    }

    private static class OneWeigher
    implements Weigher<String, ImmutableList<IIngredientListElement>> {
        private OneWeigher() {
        }

        public int weigh(String key, ImmutableList<IIngredientListElement> value) {
            return 1;
        }
    }
}

