/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.api.IItemBlacklist;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.config.Config;
import mezz.jei.util.IngredientUtil;
import mezz.jei.util.Log;
import net.minecraft.item.ItemStack;

public class ItemBlacklist
implements IItemBlacklist {
    private final IIngredientHelper<ItemStack> ingredientHelper;
    private final Set<String> itemBlacklist = new HashSet<String>();

    public ItemBlacklist(IIngredientRegistry ingredientRegistry) {
        this.ingredientHelper = ingredientRegistry.getIngredientHelper(ItemStack.class);
    }

    @Override
    public void addItemToBlacklist(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            Log.error("Null itemStack", new NullPointerException());
            return;
        }
        if (itemStack.func_77973_b() == null) {
            Log.error("Null item in itemStack", new NullPointerException());
            return;
        }
        String uid = this.ingredientHelper.getUniqueId(itemStack);
        this.itemBlacklist.add(uid);
    }

    @Override
    public void removeItemFromBlacklist(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            Log.error("Null itemStack", new NullPointerException());
            return;
        }
        if (itemStack.func_77973_b() == null) {
            Log.error("Null item in itemStack", new NullPointerException());
            return;
        }
        String uid = this.ingredientHelper.getUniqueId(itemStack);
        this.itemBlacklist.remove(uid);
    }

    @Override
    public boolean isItemBlacklisted(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            Log.error("Null itemStack", new NullPointerException());
            return false;
        }
        if (itemStack.func_77973_b() == null) {
            Log.error("Null item in itemStack", new NullPointerException());
            return false;
        }
        return this.isItemBlacklistedByApi(itemStack) || Config.isIngredientOnConfigBlacklist(itemStack, this.ingredientHelper);
    }

    public boolean isItemBlacklistedByApi(ItemStack itemStack) {
        List<String> uids = IngredientUtil.getUniqueIdsWithWildcard(this.ingredientHelper, itemStack);
        for (String uid : uids) {
            if (!this.itemBlacklist.contains(uid)) continue;
            return true;
        }
        return false;
    }
}

