/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.anvil;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.ISmithingCategoryExtension;
import mezz.jei.common.platform.IPlatformRecipeHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;

public abstract class SmithingCategoryExtension<R extends SmithingRecipe>
implements ISmithingCategoryExtension<R> {
    private final IPlatformRecipeHelper recipeHelper;

    public SmithingCategoryExtension(IPlatformRecipeHelper recipeHelper) {
        this.recipeHelper = recipeHelper;
    }

    public <T extends IIngredientAcceptor<T>> void setTemplate(R recipe, T ingredientAcceptor) {
        this.recipeHelper.getTemplate(recipe).ifPresent(arg_0 -> ingredientAcceptor.add(arg_0));
    }

    public <T extends IIngredientAcceptor<T>> void setBase(R recipe, T ingredientAcceptor) {
        Ingredient base = this.recipeHelper.getBase(recipe);
        ingredientAcceptor.add(base);
    }

    public <T extends IIngredientAcceptor<T>> void setAddition(R recipe, T ingredientAcceptor) {
        this.recipeHelper.getAddition(recipe).ifPresent(arg_0 -> ingredientAcceptor.add(arg_0));
    }

    public <T extends IIngredientAcceptor<T>> void setOutput(R recipe, T ingredientAcceptor) {
        List<ItemStack> baseStacks;
        Optional templateIngredient = this.recipeHelper.getTemplate(recipe);
        Ingredient baseIngredient = this.recipeHelper.getBase(recipe);
        Optional additionIngredient = this.recipeHelper.getAddition(recipe);
        Minecraft minecraft = Minecraft.getInstance();
        ContextMap contextmap = SlotDisplayContext.fromLevel((Level)((Level)Objects.requireNonNull(minecraft.level)));
        List<ItemStack> templateStacks = templateIngredient.map(i -> i.display().resolveForStacks(contextmap)).orElse(List.of(ItemStack.EMPTY));
        if (templateStacks.isEmpty()) {
            templateStacks = List.of(ItemStack.EMPTY);
        }
        if ((baseStacks = baseIngredient.display().resolveForStacks(contextmap)).isEmpty()) {
            baseStacks = List.of(ItemStack.EMPTY);
        }
        ItemStack addition = additionIngredient.map(i -> i.display().resolveForFirstStack(contextmap)).orElse(ItemStack.EMPTY);
        for (ItemStack template : templateStacks) {
            for (ItemStack base : baseStacks) {
                SmithingRecipeInput recipeInput = new SmithingRecipeInput(template, base, addition);
                ItemStack output = recipe.assemble((RecipeInput)recipeInput);
                ingredientAcceptor.add(output);
            }
        }
    }
}

