/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.crafting.replacers;

import java.util.List;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.common.util.RegistryUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackTemplate;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;

public final class TippedArrowRecipeMaker {
    public static List<RecipeHolder<CraftingRecipe>> createRecipes(IJeiHelpers jeiHelpers) {
        IVanillaRecipeFactory vanillaRecipeFactory = jeiHelpers.getVanillaRecipeFactory();
        String group = "jei.tipped.arrow";
        Ingredient arrowIngredient = Ingredient.of((ItemLike)Items.ARROW);
        Registry potionRegistry = RegistryUtil.getRegistry((ResourceKey)Registries.POTION);
        return potionRegistry.listElements().map(potion -> {
            ItemStack input = PotionContents.createItemStack((Item)Items.LINGERING_POTION, (Holder)potion);
            ItemStack output = PotionContents.createItemStack((Item)Items.TIPPED_ARROW, (Holder)potion);
            output.setCount(8);
            Ingredient potionIngredient = Ingredient.of((ItemLike)input.getItem());
            Identifier potionId = potion.key().identifier();
            Identifier recipeId = Identifier.fromNamespaceAndPath((String)"minecraft", (String)("jei.tipped.arrow." + potionId.getNamespace() + "." + potionId.getPath()));
            ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)recipeId);
            SlotDisplay.ItemStackSlotDisplay slotDisplay = new SlotDisplay.ItemStackSlotDisplay(ItemStackTemplate.fromNonEmptyStack((ItemStack)output));
            CraftingRecipe recipe = vanillaRecipeFactory.createShapedRecipeBuilder(CraftingBookCategory.MISC, (SlotDisplay)slotDisplay).group(group).define(Character.valueOf('a'), arrowIngredient).define(Character.valueOf('p'), potionIngredient, (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(ItemStackTemplate.fromNonEmptyStack((ItemStack)input))).pattern("aaa").pattern("apa").pattern("aaa").build();
            return new RecipeHolder(resourceKey, (Recipe)recipe);
        }).toList();
    }

    private TippedArrowRecipeMaker() {
    }
}

