/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.debug.ingredients;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.library.plugins.debug.ingredients.DebugIngredient;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.TooltipFlag;

public class DebugIngredientRenderer
implements IIngredientRenderer<DebugIngredient> {
    private final IIngredientHelper<DebugIngredient> ingredientHelper;

    public DebugIngredientRenderer(IIngredientHelper<DebugIngredient> ingredientHelper) {
        this.ingredientHelper = ingredientHelper;
    }

    public void render(GuiGraphics guiGraphics, DebugIngredient ingredient) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = this.getFontRenderer(minecraft, ingredient);
        guiGraphics.drawString(font, "JEI", 0, 0, -65536, false);
        guiGraphics.drawString(font, "#" + ingredient.number(), 0, 8, -65536, false);
    }

    public List<Component> getTooltip(DebugIngredient ingredient, TooltipFlag tooltipFlag) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        String displayName = this.ingredientHelper.getDisplayName((Object)ingredient);
        tooltip.add((Component)Component.literal((String)displayName));
        MutableComponent debugIngredient = Component.literal((String)"debug ingredient");
        tooltip.add((Component)debugIngredient.withStyle(ChatFormatting.GRAY));
        return tooltip;
    }
}

