/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.load.registration;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.SequencedMap;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.registration.IExtraIngredientRegistration;
import mezz.jei.api.registration.IIngredientAliasRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.ingredients.IngredientInfo;
import mezz.jei.library.ingredients.IngredientManager;
import mezz.jei.library.ingredients.RegisteredIngredients;
import mezz.jei.library.ingredients.TypedIngredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IngredientManagerBuilder
implements IModIngredientRegistration,
IIngredientAliasRegistration,
IExtraIngredientRegistration {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SequencedMap<IIngredientType<?>, IngredientInfo<?>> ingredientInfos = new LinkedHashMap();
    private final ISubtypeManager subtypeManager;
    private final IColorHelper colorHelper;

    public IngredientManagerBuilder(ISubtypeManager subtypeManager, IColorHelper colorHelper) {
        this.subtypeManager = subtypeManager;
        this.colorHelper = colorHelper;
    }

    public <V> void register(IIngredientType<V> ingredientType, Collection<V> allIngredients, IIngredientHelper<V> ingredientHelper, IIngredientRenderer<V> ingredientRenderer, Codec<V> ingredientCodec) {
        ErrorUtil.checkNotNull(ingredientType, (String)"ingredientType");
        ErrorUtil.checkNotNull(allIngredients, (String)"allIngredients");
        ErrorUtil.checkNotNull(ingredientHelper, (String)"ingredientHelper");
        ErrorUtil.checkNotNull(ingredientRenderer, (String)"ingredientRenderer");
        ErrorUtil.checkNotNull(ingredientCodec, (String)"ingredientCodec");
        Preconditions.checkArgument((ingredientRenderer.getWidth() == 16 ? 1 : 0) != 0, (Object)"the default ingredient renderer registered here will be used for drawing ingredients in the ingredient list, and it must have a width of 16");
        Preconditions.checkArgument((ingredientRenderer.getHeight() == 16 ? 1 : 0) != 0, (Object)"the default ingredient renderer registered here will be used for drawing ingredients in the ingredient list, and it must have a height of 16");
        if (this.ingredientInfos.containsKey(ingredientType)) {
            throw new IllegalArgumentException("Ingredient type has already been registered: " + String.valueOf(ingredientType.getIngredientClass()));
        }
        ArrayList allTypedIngredients = new ArrayList(allIngredients.size());
        for (V ingredient : allIngredients) {
            if (!ingredientHelper.isIngredientOnServer(ingredient)) {
                String errorInfo = ingredientHelper.getErrorInfo(ingredient);
                LOGGER.warn("Attempted to add an Ingredient that is not on the server: {}", (Object)errorInfo);
                continue;
            }
            ITypedIngredient<V> typedIngredient = TypedIngredient.createAndFilterInvalid(ingredientHelper, ingredientType, ingredient, false);
            if (typedIngredient == null) {
                LOGGER.warn("Detected an invalid ingredient during ingredient registration: {}", (Object)ingredientHelper.getErrorInfo(ingredient));
                continue;
            }
            allTypedIngredients.add(typedIngredient);
        }
        this.ingredientInfos.put(ingredientType, new IngredientInfo<V>(ingredientType, allTypedIngredients, ingredientHelper, ingredientRenderer, ingredientCodec));
    }

    public <V> void addExtraIngredients(IIngredientType<V> ingredientType, Collection<V> extraIngredients) {
        ErrorUtil.checkNotNull(ingredientType, (String)"ingredientType");
        ErrorUtil.checkNotNull(extraIngredients, (String)"extraIngredients");
        IngredientInfo<V> castIngredientInfo = this.getIngredientInfo(ingredientType);
        IIngredientHelper<V> ingredientHelper = castIngredientInfo.getIngredientHelper();
        ArrayList extraTypedIngredients = new ArrayList(extraIngredients.size());
        for (V ingredient : extraIngredients) {
            if (!ingredientHelper.isIngredientOnServer(ingredient)) {
                String errorInfo = ingredientHelper.getErrorInfo(ingredient);
                LOGGER.warn("Attempted to add an extra Ingredient that is not on the server: {}", (Object)errorInfo);
                continue;
            }
            ITypedIngredient<V> typedIngredient = TypedIngredient.createAndFilterInvalid(ingredientHelper, ingredientType, ingredient, false);
            if (typedIngredient == null) {
                LOGGER.warn("Detected an invalid ingredient when adding extra ingredients: {}", (Object)ingredientHelper.getErrorInfo(ingredient));
                continue;
            }
            extraTypedIngredients.add(typedIngredient);
        }
        castIngredientInfo.addIngredients(extraTypedIngredients);
    }

    public <I> void addAlias(IIngredientType<I> type, I ingredient, String alias) {
        ErrorUtil.checkNotNull(type, (String)"type");
        ErrorUtil.checkNotNull(ingredient, (String)"ingredient");
        ErrorUtil.checkNotNull((Object)alias, (String)"alias");
        IngredientInfo<I> ingredientInfo = this.getIngredientInfo(type);
        ingredientInfo.addIngredientAlias(ingredient, alias);
    }

    public <I> void addAlias(ITypedIngredient<I> typedIngredient, String alias) {
        ErrorUtil.checkNotNull(typedIngredient, (String)"typedIngredient");
        ErrorUtil.checkNotNull((Object)alias, (String)"alias");
        IngredientInfo<I> ingredientInfo = this.getIngredientInfo(typedIngredient.getType());
        ingredientInfo.addIngredientAlias(typedIngredient, alias);
    }

    public <I> void addAliases(IIngredientType<I> type, I ingredient, Collection<String> aliases) {
        ErrorUtil.checkNotNull(type, (String)"type");
        ErrorUtil.checkNotNull(ingredient, (String)"ingredient");
        ErrorUtil.checkNotNull(aliases, (String)"aliases");
        IngredientInfo<I> ingredientInfo = this.getIngredientInfo(type);
        ingredientInfo.addIngredientAliases(ingredient, aliases);
    }

    public <I> void addAliases(ITypedIngredient<I> typedIngredient, Collection<String> aliases) {
        ErrorUtil.checkNotNull(typedIngredient, (String)"typedIngredient");
        ErrorUtil.checkNotNull(aliases, (String)"aliases");
        IngredientInfo<I> ingredientInfo = this.getIngredientInfo(typedIngredient.getType());
        ingredientInfo.addIngredientAliases(typedIngredient, aliases);
    }

    public <I> void addAliases(IIngredientType<I> type, Collection<I> ingredients, String alias) {
        ErrorUtil.checkNotNull(type, (String)"type");
        ErrorUtil.checkNotNull(ingredients, (String)"ingredients");
        ErrorUtil.checkNotNull((Object)alias, (String)"alias");
        IngredientInfo<I> ingredientInfo = this.getIngredientInfo(type);
        for (I ingredient : ingredients) {
            ingredientInfo.addIngredientAlias(ingredient, alias);
        }
    }

    public <I> void addAliases(Collection<ITypedIngredient<I>> typedIngredients, String alias) {
        ErrorUtil.checkNotNull(typedIngredients, (String)"typedIngredients");
        ErrorUtil.checkNotNull((Object)alias, (String)"alias");
        IngredientInfo<I> ingredientInfo = null;
        for (ITypedIngredient<I> typedIngredient : typedIngredients) {
            IIngredientType ingredientType = typedIngredient.getType();
            if (ingredientInfo == null) {
                ingredientInfo = this.getIngredientInfo(ingredientType);
            }
            ingredientInfo.addIngredientAlias(typedIngredient, alias);
        }
    }

    public <I> void addAliases(IIngredientType<I> type, Collection<I> ingredients, Collection<String> aliases) {
        ErrorUtil.checkNotNull(type, (String)"type");
        ErrorUtil.checkNotNull(ingredients, (String)"ingredients");
        ErrorUtil.checkNotNull(aliases, (String)"aliases");
        IngredientInfo<I> ingredientInfo = this.getIngredientInfo(type);
        for (I ingredient : ingredients) {
            ingredientInfo.addIngredientAliases(ingredient, aliases);
        }
    }

    public <I> void addAliases(Collection<ITypedIngredient<I>> typedIngredients, Collection<String> aliases) {
        ErrorUtil.checkNotNull(typedIngredients, (String)"typedIngredients");
        ErrorUtil.checkNotNull(aliases, (String)"aliases");
        IngredientInfo<I> ingredientInfo = null;
        for (ITypedIngredient<I> typedIngredient : typedIngredients) {
            IIngredientType ingredientType = typedIngredient.getType();
            if (ingredientInfo == null) {
                ingredientInfo = this.getIngredientInfo(ingredientType);
            }
            ingredientInfo.addIngredientAliases(typedIngredient, aliases);
        }
    }

    private <T> IngredientInfo<T> getIngredientInfo(IIngredientType<T> ingredientType) {
        IngredientInfo ingredientInfo = (IngredientInfo)this.ingredientInfos.get(ingredientType);
        if (ingredientInfo == null) {
            throw new IllegalArgumentException("Ingredient type has not been registered: " + ingredientType.getUid());
        }
        IngredientInfo cast = ingredientInfo;
        return cast;
    }

    public ISubtypeManager getSubtypeManager() {
        return this.subtypeManager;
    }

    public IColorHelper getColorHelper() {
        return this.colorHelper;
    }

    public IngredientManager build() {
        RegisteredIngredients registeredIngredients = new RegisteredIngredients(this.ingredientInfos);
        return new IngredientManager(registeredIngredients);
    }
}

