/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.helpers;

import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.widgets.IScrollBoxWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.elements.DrawableAnimated;
import mezz.jei.common.gui.elements.DrawableBlank;
import mezz.jei.common.gui.elements.DrawableCombined;
import mezz.jei.common.gui.elements.DrawableIngredient;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.TickTimer;
import mezz.jei.library.gui.elements.DrawableBuilder;
import mezz.jei.library.gui.helpers.CraftingGridHelper;
import mezz.jei.library.gui.widgets.ScrollBoxRecipeWidget;
import net.minecraft.resources.Identifier;

public class GuiHelper
implements IGuiHelper {
    private final IIngredientManager ingredientManager;

    public GuiHelper(IIngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
    }

    public IDrawableBuilder drawableBuilder(Identifier id, int u, int v, int width, int height) {
        return new DrawableBuilder(id, u, v, width, height);
    }

    public IDrawableAnimated createAnimatedDrawable(IDrawableStatic drawable, int ticksPerCycle, IDrawableAnimated.StartDirection startDirection, boolean inverted) {
        ErrorUtil.checkNotNull((Object)drawable, (String)"drawable");
        ErrorUtil.checkNotNull((Object)startDirection, (String)"startDirection");
        return new DrawableAnimated(drawable, ticksPerCycle, startDirection, inverted);
    }

    public IDrawableAnimated createAnimatedDrawable(IDrawableStatic drawable, ITickTimer tickTimer, IDrawableAnimated.StartDirection startDirection) {
        ErrorUtil.checkNotNull((Object)drawable, (String)"drawable");
        ErrorUtil.checkNotNull((Object)tickTimer, (String)"tickTimer");
        ErrorUtil.checkNotNull((Object)startDirection, (String)"startDirection");
        return new DrawableAnimated(drawable, tickTimer, startDirection);
    }

    public IDrawableStatic getSlotDrawable() {
        Textures textures = Internal.getTextures();
        return textures.getSlot();
    }

    public IDrawableStatic getOutputSlot() {
        Textures textures = Internal.getTextures();
        return textures.getOutputSlot();
    }

    public IDrawableStatic getRecipeArrow() {
        Textures textures = Internal.getTextures();
        return textures.getRecipeArrow();
    }

    public IDrawableStatic getRecipeArrowFilled() {
        Textures textures = Internal.getTextures();
        return textures.getRecipeArrowFilled();
    }

    public IDrawableAnimated createAnimatedRecipeArrow(int ticksPerCycle) {
        IDrawableAnimated animatedFill = this.createAnimatedDrawable(this.getRecipeArrowFilled(), ticksPerCycle, IDrawableAnimated.StartDirection.LEFT, false);
        return new DrawableCombined(new IDrawable[]{this.getRecipeArrow(), animatedFill});
    }

    public IDrawableStatic getRecipePlusSign() {
        Textures textures = Internal.getTextures();
        return textures.getRecipePlusSign();
    }

    public IDrawableStatic getRecipeFlameEmpty() {
        Textures textures = Internal.getTextures();
        return textures.getFlameEmptyIcon();
    }

    public IDrawableStatic getRecipeFlameFilled() {
        Textures textures = Internal.getTextures();
        return textures.getFlameIcon();
    }

    public IDrawableAnimated createAnimatedRecipeFlame(int ticksPerCycle) {
        IDrawableAnimated animatedFill = this.createAnimatedDrawable(this.getRecipeFlameFilled(), ticksPerCycle, IDrawableAnimated.StartDirection.TOP, true);
        return new DrawableCombined(new IDrawable[]{this.getRecipeFlameEmpty(), animatedFill});
    }

    public IDrawableStatic createBlankDrawable(int width, int height) {
        return new DrawableBlank(width, height);
    }

    public <V> IDrawable createDrawableIngredient(IIngredientType<V> type, V ingredient) {
        ErrorUtil.checkNotNull(type, (String)"type");
        ErrorUtil.checkNotNull(ingredient, (String)"ingredient");
        IIngredientRenderer ingredientRenderer = this.ingredientManager.getIngredientRenderer(type);
        ITypedIngredient typedIngredient = (ITypedIngredient)this.ingredientManager.createTypedIngredient(type, ingredient, false).orElseThrow(() -> {
            String info = ErrorUtil.getIngredientInfo((Object)ingredient, (IIngredientType)type, (IIngredientManager)this.ingredientManager);
            return new IllegalArgumentException(String.format("Ingredient is invalid and cannot be used as a drawable ingredient: %s", info));
        });
        return new DrawableIngredient(typedIngredient, ingredientRenderer);
    }

    public <V> IDrawable createDrawableIngredient(ITypedIngredient<V> ingredient) {
        ErrorUtil.checkNotNull(ingredient, (String)"ingredient");
        IIngredientType type = ingredient.getType();
        IIngredientRenderer ingredientRenderer = this.ingredientManager.getIngredientRenderer(type);
        return new DrawableIngredient(ingredient, ingredientRenderer);
    }

    public ICraftingGridHelper createCraftingGridHelper() {
        return CraftingGridHelper.INSTANCE;
    }

    public IScrollBoxWidget createScrollBoxWidget(int width, int height, int xPos, int yPos) {
        return new ScrollBoxRecipeWidget(width, height, xPos, yPos);
    }

    public ITickTimer createTickTimer(int ticksPerCycle, int maxValue, boolean countDown) {
        return new TickTimer(ticksPerCycle, maxValue, countDown);
    }
}

