/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.transfer;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import org.jspecify.annotations.Nullable;

public class BasicRecipeTransferInfo<C extends AbstractContainerMenu, R>
implements IRecipeTransferInfo<C, R> {
    private final Class<? extends C> containerClass;
    private final @Nullable MenuType<C> menuType;
    private final IRecipeType<R> recipeType;
    private final int recipeSlotStart;
    private final int recipeSlotCount;
    private final int inventorySlotStart;
    private final int inventorySlotCount;

    public BasicRecipeTransferInfo(Class<? extends C> containerClass, @Nullable MenuType<C> menuType, IRecipeType<R> recipeType, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount) {
        this.containerClass = containerClass;
        this.menuType = menuType;
        this.recipeType = recipeType;
        this.recipeSlotStart = recipeSlotStart;
        this.recipeSlotCount = recipeSlotCount;
        this.inventorySlotStart = inventorySlotStart;
        this.inventorySlotCount = inventorySlotCount;
    }

    public Class<? extends C> getContainerClass() {
        return this.containerClass;
    }

    public Optional<MenuType<C>> getMenuType() {
        return Optional.ofNullable(this.menuType);
    }

    public IRecipeType<R> getRecipeType() {
        return this.recipeType;
    }

    public boolean canHandle(C container, R recipe) {
        return true;
    }

    public List<Slot> getRecipeSlots(C container, R recipe) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = this.recipeSlotStart; i < this.recipeSlotStart + this.recipeSlotCount; ++i) {
            Slot slot = container.getSlot(i);
            slots.add(slot);
        }
        return slots;
    }

    public List<Slot> getInventorySlots(C container, R recipe) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = this.inventorySlotStart; i < this.inventorySlotStart + this.inventorySlotCount; ++i) {
            Slot slot = container.getSlot(i);
            slots.add(slot);
        }
        return slots;
    }
}

