/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.common.platform.Services;
import mezz.jei.library.gui.helpers.GuiHelper;
import mezz.jei.library.ingredients.IngredientVisibility;
import net.minecraft.resources.Identifier;
import org.jspecify.annotations.Nullable;

public class JeiHelpers
implements IJeiHelpers {
    private final GuiHelper guiHelper;
    private final IStackHelper stackHelper;
    private final IModIdHelper modIdHelper;
    private final IFocusFactory focusFactory;
    private final IColorHelper colorHelper;
    private final IIngredientManager ingredientManager;
    private final IVanillaRecipeFactory vanillaRecipeFactory;
    private final IngredientVisibility ingredientVisibility;
    private final IPlatformFluidHelper<?> platformFluidHelper;
    private final ICodecHelper codecHelper;
    private @Nullable Collection<IRecipeCategory<?>> recipeCategories;

    public JeiHelpers(GuiHelper guiHelper, IStackHelper stackHelper, IModIdHelper modIdHelper, IFocusFactory focusFactory, IColorHelper colorHelper, IIngredientManager ingredientManager, IVanillaRecipeFactory vanillaRecipeFactory, ICodecHelper codecHelper, IngredientVisibility ingredientVisibility) {
        this.guiHelper = guiHelper;
        this.stackHelper = stackHelper;
        this.modIdHelper = modIdHelper;
        this.focusFactory = focusFactory;
        this.colorHelper = colorHelper;
        this.ingredientManager = ingredientManager;
        this.vanillaRecipeFactory = vanillaRecipeFactory;
        this.ingredientVisibility = ingredientVisibility;
        this.platformFluidHelper = Services.PLATFORM.getFluidHelper();
        this.codecHelper = codecHelper;
    }

    public void setRecipeCategories(Collection<IRecipeCategory<?>> recipeCategories) {
        this.recipeCategories = Collections.unmodifiableCollection(recipeCategories);
    }

    public IGuiHelper getGuiHelper() {
        return this.guiHelper;
    }

    public IStackHelper getStackHelper() {
        return this.stackHelper;
    }

    public IModIdHelper getModIdHelper() {
        return this.modIdHelper;
    }

    public IFocusFactory getFocusFactory() {
        return this.focusFactory;
    }

    public IColorHelper getColorHelper() {
        return this.colorHelper;
    }

    public IPlatformFluidHelper<?> getPlatformFluidHelper() {
        return this.platformFluidHelper;
    }

    public <T> Optional<IRecipeType<T>> getRecipeType(Identifier uid, Class<? extends T> recipeClass) {
        return this.getRecipeType(uid).filter(t -> t.getRecipeClass().equals(recipeClass)).map(t -> {
            IRecipeType cast = t;
            return cast;
        });
    }

    public Optional<IRecipeType<?>> getRecipeType(Identifier uid) {
        return Optional.ofNullable(this.recipeCategories).flatMap(r -> r.stream().map(IRecipeCategory::getRecipeType).filter(t -> t.getUid().equals((Object)uid)).findFirst());
    }

    public Stream<IRecipeType<?>> getAllRecipeTypes() {
        if (this.recipeCategories == null) {
            return Stream.of(new IRecipeType[0]);
        }
        return this.recipeCategories.stream().map(IRecipeCategory::getRecipeType);
    }

    public IIngredientManager getIngredientManager() {
        return this.ingredientManager;
    }

    public ICodecHelper getCodecHelper() {
        return this.codecHelper;
    }

    public IVanillaRecipeFactory getVanillaRecipeFactory() {
        return this.vanillaRecipeFactory;
    }

    public IIngredientVisibility getIngredientVisibility() {
        return this.ingredientVisibility;
    }

    public void onRuntimeStopped() {
        this.ingredientVisibility.onRuntimeStopped();
    }
}

