/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.recipes;

import java.util.Collection;
import java.util.stream.Stream;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeLookup;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.library.focus.FocusGroup;
import mezz.jei.library.recipes.RecipeManagerInternal;

public class RecipeLookup<R>
implements IRecipeLookup<R> {
    private final IRecipeType<R> recipeType;
    private final RecipeManagerInternal recipeManager;
    private final IIngredientManager ingredientManager;
    private boolean includeHidden = false;
    private IFocusGroup focusGroup = FocusGroup.EMPTY;

    public RecipeLookup(IRecipeType<R> recipeType, RecipeManagerInternal recipeManager, IIngredientManager ingredientManager) {
        this.recipeType = recipeType;
        this.recipeManager = recipeManager;
        this.ingredientManager = ingredientManager;
    }

    public IRecipeLookup<R> limitFocus(Collection<? extends IFocus<?>> focuses) {
        this.focusGroup = FocusGroup.create(focuses, this.ingredientManager);
        return this;
    }

    public IRecipeLookup<R> includeHidden() {
        this.includeHidden = true;
        return this;
    }

    public Stream<R> get() {
        return this.recipeManager.getRecipesStream(this.recipeType, this.focusGroup, this.includeHidden);
    }
}

