/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.load.registration;

import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.api.recipe.transfer.IUniversalRecipeTransferHandler;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.core.collect.Table;
import mezz.jei.library.recipes.RecipeTransferManager;
import mezz.jei.library.recipes.UniversalRecipeTransferHandlerAdapter;
import mezz.jei.library.transfer.BasicRecipeTransferHandler;
import mezz.jei.library.transfer.BasicRecipeTransferInfo;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import org.jspecify.annotations.Nullable;

public class RecipeTransferRegistration
implements IRecipeTransferRegistration {
    private final Table<Class<? extends AbstractContainerMenu>, IRecipeType<?>, IRecipeTransferHandler<?, ?>> recipeTransferHandlers = Table.hashBasedTable();
    private final IStackHelper stackHelper;
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final IJeiHelpers jeiHelpers;
    private final IConnectionToServer serverConnection;

    public RecipeTransferRegistration(IStackHelper stackHelper, IRecipeTransferHandlerHelper handlerHelper, IJeiHelpers jeiHelpers, IConnectionToServer serverConnection) {
        this.stackHelper = stackHelper;
        this.handlerHelper = handlerHelper;
        this.jeiHelpers = jeiHelpers;
        this.serverConnection = serverConnection;
    }

    public IJeiHelpers getJeiHelpers() {
        return this.jeiHelpers;
    }

    public IRecipeTransferHandlerHelper getTransferHelper() {
        return this.handlerHelper;
    }

    public <C extends AbstractContainerMenu, R> void addRecipeTransferHandler(Class<? extends C> containerClass, @Nullable MenuType<C> menuType, IRecipeType<R> recipeType, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount) {
        ErrorUtil.checkNotNull(containerClass, (String)"containerClass");
        ErrorUtil.checkNotNull(recipeType, (String)"recipeType");
        BasicRecipeTransferInfo<? extends C, R> recipeTransferInfo = new BasicRecipeTransferInfo<C, R>(containerClass, menuType, recipeType, recipeSlotStart, recipeSlotCount, inventorySlotStart, inventorySlotCount);
        this.addRecipeTransferHandler(recipeTransferInfo);
    }

    public <C extends AbstractContainerMenu, R> void addRecipeTransferHandler(IRecipeTransferInfo<C, R> recipeTransferInfo) {
        ErrorUtil.checkNotNull(recipeTransferInfo, (String)"recipeTransferInfo");
        BasicRecipeTransferHandler<C, R> recipeTransferHandler = new BasicRecipeTransferHandler<C, R>(this.serverConnection, this.stackHelper, this.handlerHelper, recipeTransferInfo);
        this.addRecipeTransferHandler(recipeTransferHandler, recipeTransferInfo.getRecipeType());
    }

    public <C extends AbstractContainerMenu, R> void addRecipeTransferHandler(IRecipeTransferHandler<C, R> recipeTransferHandler, IRecipeType<R> recipeType) {
        ErrorUtil.checkNotNull(recipeTransferHandler, (String)"recipeTransferHandler");
        ErrorUtil.checkNotNull(recipeType, (String)"recipeType");
        Class containerClass = recipeTransferHandler.getContainerClass();
        this.recipeTransferHandlers.put((Object)containerClass, recipeType, recipeTransferHandler);
    }

    public <C extends AbstractContainerMenu> void addUniversalRecipeTransferHandler(IUniversalRecipeTransferHandler<C> universalRecipeTransferHandler) {
        ErrorUtil.checkNotNull(universalRecipeTransferHandler, (String)"universalRecipeTransferHandler");
        Class containerClass = universalRecipeTransferHandler.getContainerClass();
        UniversalRecipeTransferHandlerAdapter adapter = new UniversalRecipeTransferHandlerAdapter(universalRecipeTransferHandler);
        this.recipeTransferHandlers.put((Object)containerClass, adapter.getRecipeType(), adapter);
    }

    public IRecipeTransferManager createRecipeTransferManager() {
        return new RecipeTransferManager(this.recipeTransferHandlers.toImmutable());
    }
}

