/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.load.registration;

import com.google.common.collect.ImmutableListMultimap;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.core.collect.ListMultiMap;
import mezz.jei.library.ingredients.TypedIngredient;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RecipeCatalystRegistration
implements IRecipeCatalystRegistration {
    private final ListMultiMap<IRecipeType<?>, ITypedIngredient<?>> recipeCatalysts = new ListMultiMap();
    private final IIngredientManager ingredientManager;
    private final IJeiHelpers jeiHelpers;

    public RecipeCatalystRegistration(IIngredientManager ingredientManager, IJeiHelpers jeiHelpers) {
        this.ingredientManager = ingredientManager;
        this.jeiHelpers = jeiHelpers;
    }

    public IIngredientManager getIngredientManager() {
        return this.ingredientManager;
    }

    public IJeiHelpers getJeiHelpers() {
        return this.jeiHelpers;
    }

    public <T> void addCraftingStations(IRecipeType<?> recipeType, IIngredientType<T> ingredientType, List<T> ingredients) {
        ErrorUtil.checkNotNull(recipeType, (String)"recipeType");
        ErrorUtil.checkNotNull(ingredientType, (String)"ingredientType");
        ErrorUtil.checkNotNull(ingredients, (String)"ingredients");
        for (T ingredient : ingredients) {
            ITypedIngredient<T> typedIngredient = TypedIngredient.createAndFilterInvalid(this.ingredientManager, ingredientType, ingredient, true);
            if (typedIngredient == null) {
                throw new IllegalArgumentException("Recipe catalyst must be a valid ingredient");
            }
            this.recipeCatalysts.put(recipeType, typedIngredient);
        }
    }

    public void addCraftingStation(IRecipeType<?> recipeType, ItemLike ... ingredients) {
        ErrorUtil.checkNotNull(recipeType, (String)"recipeType");
        ErrorUtil.checkNotNull((Object)ingredients, (String)"ingredients");
        for (ItemLike itemLike : ingredients) {
            ItemStack itemStack = itemLike.asItem().getDefaultInstance();
            ITypedIngredient<ItemStack> typedIngredient = TypedIngredient.createAndFilterInvalid(this.ingredientManager, VanillaTypes.ITEM_STACK, itemStack, true);
            if (typedIngredient == null) {
                throw new IllegalArgumentException("Recipe catalyst must be a valid ingredient");
            }
            this.recipeCatalysts.put(recipeType, typedIngredient);
        }
    }

    public <T> void addCraftingStation(IRecipeType<?> recipeType, IIngredientType<T> ingredientType, T ingredient) {
        ErrorUtil.checkNotNull(recipeType, (String)"recipeType");
        ErrorUtil.checkNotNull(ingredientType, (String)"ingredientType");
        ErrorUtil.checkNotNull(ingredient, (String)"ingredient");
        ITypedIngredient<T> typedIngredient = TypedIngredient.createAndFilterInvalid(this.ingredientManager, ingredientType, ingredient, true);
        if (typedIngredient == null) {
            throw new IllegalArgumentException("Recipe catalyst must be a valid ingredient");
        }
        this.recipeCatalysts.put(recipeType, typedIngredient);
    }

    public <T> void addRecipeCatalyst(IIngredientType<T> ingredientType, T ingredient, IRecipeType<?> ... recipeTypes) {
        ErrorUtil.checkNotEmpty((Object[])recipeTypes, (String)"recipeTypes");
        ErrorUtil.checkNotNull(ingredientType, (String)"ingredientType");
        ErrorUtil.checkNotNull(ingredient, (String)"ingredient");
        for (IRecipeType<?> recipeType : recipeTypes) {
            ErrorUtil.checkNotNull(recipeType, (String)"recipeType");
            ITypedIngredient<T> typedIngredient = TypedIngredient.createAndFilterInvalid(this.ingredientManager, ingredientType, ingredient, true);
            if (typedIngredient == null) {
                throw new IllegalArgumentException("Recipe catalyst must be a valid ingredient");
            }
            this.recipeCatalysts.put(recipeType, typedIngredient);
        }
    }

    public ImmutableListMultimap<IRecipeType<?>, ITypedIngredient<?>> getRecipeCatalysts() {
        return this.recipeCatalysts.toImmutable();
    }
}

