/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes.lookups;

import java.util.Collection;
import java.util.List;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.gui.recipes.lookups.IFocusedRecipes;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.Nullable;

public class FocusedRecipes<T>
implements IFocusedRecipes<T> {
    private final IRecipeManager recipeManager;
    private final IRecipeCategory<T> recipeCategory;
    private final IFocusGroup focuses;
    private @Nullable List<T> recipes;

    public static <T> IFocusedRecipes<T> create(IFocusGroup focuses, IRecipeManager recipeManager, IRecipeCategory<T> recipeCategory) {
        return new FocusedRecipes<T>(focuses, recipeManager, recipeCategory);
    }

    private FocusedRecipes(IFocusGroup focuses, IRecipeManager recipeManager, IRecipeCategory<T> recipeCategory) {
        this.focuses = focuses;
        this.recipeManager = recipeManager;
        this.recipeCategory = recipeCategory;
        this.recipes = null;
    }

    @Override
    public IRecipeCategory<T> getRecipeCategory() {
        return this.recipeCategory;
    }

    @Override
    public @Unmodifiable List<T> getRecipes() {
        if (this.recipes == null) {
            this.recipes = this.recipeManager.createRecipeLookup(this.recipeCategory.getRecipeType()).limitFocus((Collection)this.focuses.getAllFocuses()).get().toList();
        }
        return this.recipes;
    }
}

