/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Either;
import mezz.jei.common.input.KeyNameUtil;
import mezz.jei.common.input.MouseButtonEventData;
import mezz.jei.gui.input.InputType;
import mezz.jei.gui.input.UserInput;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;

public class MouseUserInput
extends UserInput {
    private final MouseButtonEventData eventData;
    private final InputConstants.Key key;
    private final InputType inputType;

    public MouseUserInput(MouseButtonEvent event, boolean doubleClick, InputType inputType) {
        this.eventData = new MouseButtonEventData(event, doubleClick);
        this.inputType = inputType;
        this.key = InputConstants.Type.MOUSE.getOrCreate(event.input());
    }

    public InputConstants.Key getKey() {
        return this.key;
    }

    @Override
    public double getMouseX() {
        return this.eventData.event().x();
    }

    @Override
    public double getMouseY() {
        return this.eventData.event().y();
    }

    @Override
    public InputType getInputType() {
        return this.inputType;
    }

    public int getModifiers() {
        return this.eventData.event().modifiers();
    }

    public InputWithModifiers getInputWithModifiers() {
        return this.eventData.event();
    }

    public boolean isSimulate() {
        return this.inputType == InputType.SIMULATE;
    }

    @Override
    public boolean isAllowedChatCharacter() {
        return false;
    }

    @Override
    public Either<MouseButtonEventData, KeyEvent> getEvent() {
        return Either.left((Object)this.eventData);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("inputType", (Object)this.inputType).add("key", (Object)KeyNameUtil.getKeyDisplayName((InputConstants.Key)this.key).getString()).add("eventData", (Object)this.eventData).toString();
    }
}

