/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.fabric.startup;

import com.mojang.blaze3d.platform.Window;
import mezz.jei.fabric.events.JeiCharTypedEvents;
import mezz.jei.fabric.events.JeiScreenEvents;
import mezz.jei.gui.events.GuiEventHandler;
import mezz.jei.gui.input.ClientInputHandler;
import mezz.jei.gui.input.InputType;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.startup.JeiEventHandlers;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import org.jspecify.annotations.Nullable;

public class EventRegistration {
    private @Nullable ClientInputHandler clientInputHandler;
    private @Nullable GuiEventHandler guiEventHandler;
    private boolean registered;

    public void setEventHandlers(JeiEventHandlers eventHandlers) {
        this.clientInputHandler = eventHandlers.clientInputHandler();
        this.guiEventHandler = eventHandlers.guiEventHandler();
        if (!this.registered) {
            this.registerEvents();
            this.registered = true;
        }
    }

    private void registerEvents() {
        ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> this.registerScreenEvents(screen));
        JeiCharTypedEvents.BEFORE_CHAR_TYPED.register(this::beforeCharTyped);
        ScreenEvents.AFTER_INIT.register(this::afterInit);
        JeiScreenEvents.DRAW_FOREGROUND.register(this::drawForeground);
        JeiScreenEvents.DRAW_BACKGROUND.register(this::drawBackground);
    }

    private void registerScreenEvents(Screen screen) {
        if (this.guiEventHandler == null) {
            return;
        }
        ScreenKeyboardEvents.allowKeyPress((Screen)screen).register(this::allowKeyPress);
        ScreenMouseEvents.allowMouseClick((Screen)screen).register(this::allowMouseClick);
        ScreenMouseEvents.allowMouseRelease((Screen)screen).register(this::allowMouseRelease);
        ScreenMouseEvents.allowMouseScroll((Screen)screen).register(this::allowMouseScroll);
    }

    private boolean allowMouseClick(Screen screen, MouseButtonEvent event) {
        if (this.clientInputHandler == null) {
            return true;
        }
        return UserInput.fromVanilla(event, false, InputType.SIMULATE).map(input -> !this.clientInputHandler.onGuiMouseClicked(screen, (UserInput)input)).orElse(true);
    }

    private boolean allowMouseRelease(Screen screen, MouseButtonEvent event) {
        if (this.clientInputHandler == null) {
            return true;
        }
        return UserInput.fromVanilla(event, false, InputType.EXECUTE).map(input -> !this.clientInputHandler.onGuiMouseReleased(screen, (UserInput)input)).orElse(true);
    }

    private boolean allowKeyPress(Screen screen, KeyEvent keyEvent) {
        if (this.clientInputHandler == null) {
            return true;
        }
        UserInput userInput = UserInput.fromVanilla(keyEvent, InputType.IMMEDIATE);
        return !this.clientInputHandler.onKeyboardKeyPressedPre(screen, userInput);
    }

    private boolean allowMouseScroll(Screen screen, double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.clientInputHandler == null) {
            return false;
        }
        return !this.clientInputHandler.onGuiMouseScroll(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private boolean beforeCharTyped(long windowHandle, CharacterEvent event) {
        Screen screen;
        Minecraft minecraft = Minecraft.getInstance();
        Window window = minecraft.getWindow();
        if (window.handle() == windowHandle && this.clientInputHandler != null && (screen = minecraft.screen) instanceof Screen) {
            Screen screen2 = screen;
            if (minecraft.getOverlay() == null) {
                return this.clientInputHandler.onKeyboardCharTypedPre(screen2, event);
            }
        }
        return false;
    }

    private void afterInit(Minecraft client, Screen screen, int scaledWidth, int scaledHeight) {
        if (this.guiEventHandler != null) {
            this.guiEventHandler.onGuiInit(screen);
            this.guiEventHandler.onGuiOpen(screen);
        }
    }

    private void drawForeground(AbstractContainerScreen<?> screen, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.guiEventHandler != null) {
            this.guiEventHandler.drawForContainerScreen(screen, guiGraphics, mouseX, mouseY);
        }
    }

    private void drawBackground(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float tickDelta) {
        if (this.guiEventHandler != null) {
            this.guiEventHandler.drawForScreen(screen, guiGraphics, mouseX, mouseY);
        }
    }

    public void clear() {
        this.clientInputHandler = null;
        this.guiEventHandler = null;
    }
}

