/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.fabric.platform;

import java.util.List;
import java.util.Optional;
import mezz.jei.common.platform.IPlatformItemStackHelper;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.entity.FuelValues;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public class ItemStackHelper
implements IPlatformItemStackHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public int getBurnTime(ItemStack itemStack, RecipeType<?> recipeType, FuelValues fuelValues) {
        return fuelValues.burnDuration(itemStack);
    }

    @Override
    public Optional<String> getCreatorModId(ItemStack stack) {
        return Optional.empty();
    }

    @Override
    public List<Component> getTestTooltip(@Nullable Player player, ItemStack itemStack) {
        try {
            return itemStack.getTooltipLines(Item.TooltipContext.EMPTY, player, (TooltipFlag)TooltipFlag.Default.NORMAL);
        }
        catch (LinkageError | RuntimeException e) {
            LOGGER.error("Error while Testing for mod name formatting", e);
            return List.of();
        }
    }

    @Override
    public boolean canEnchant(Holder<Enchantment> enchantment, ItemStack ingredient) {
        return ingredient.canBeEnchantedWith(enchantment, EnchantingContext.ACCEPTABLE);
    }
}

