/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.fabric.input;

import com.mojang.blaze3d.platform.InputConstants;
import mezz.jei.common.input.keys.JeiKeyConflictContext;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;

public class FabricKeyMapping
extends KeyMapping {
    protected InputConstants.Key realKey = KeyBindingHelper.getBoundKeyOf((KeyMapping)this);
    protected final JeiKeyConflictContext context;

    public FabricKeyMapping(String description, InputConstants.Type type, int keyCode, KeyMapping.Category category, JeiKeyConflictContext context) {
        super(description, type, keyCode, category);
        this.context = context;
        super.setKey(InputConstants.UNKNOWN);
    }

    public void setKey(InputConstants.Key key) {
        this.realKey = key;
    }

    public boolean same(KeyMapping binding) {
        if (binding instanceof FabricKeyMapping) {
            FabricKeyMapping other = (FabricKeyMapping)binding;
            return this.realKey.equals((Object)KeyBindingHelper.getBoundKeyOf((KeyMapping)other)) && (this.context.conflicts(other.context) || other.context.conflicts(this.context));
        }
        return false;
    }

    public boolean isUnbound() {
        return this.realKey.equals((Object)InputConstants.UNKNOWN);
    }

    public boolean matches(KeyEvent keyEvent) {
        int keyCode = keyEvent.key();
        if (keyCode != InputConstants.UNKNOWN.getValue()) {
            return this.realKey.getType() == InputConstants.Type.KEYSYM && this.realKey.getValue() == keyCode;
        }
        return this.realKey.getType() == InputConstants.Type.SCANCODE && this.realKey.getValue() == keyEvent.scancode();
    }

    public boolean matchesMouse(MouseButtonEvent mouseButtonEvent) {
        return this.realKey.getType() == InputConstants.Type.MOUSE && this.realKey.getValue() == mouseButtonEvent.button();
    }

    public Component getTranslatedKeyMessage() {
        return this.realKey.getDisplayName();
    }

    public boolean isDefault() {
        return this.realKey.equals((Object)this.getDefaultKey());
    }

    public String saveString() {
        return this.realKey.getName();
    }
}

