/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Either;
import mezz.jei.common.input.KeyNameUtil;
import mezz.jei.gui.input.InputType;
import mezz.jei.gui.input.UserInput;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;

public class MouseUserInput
extends UserInput {
    private final MouseButtonEvent event;
    private final boolean doubleClick;
    private final InputConstants.Key key;
    private final InputType inputType;

    public MouseUserInput(MouseButtonEvent event, boolean doubleClick, InputType inputType) {
        this.event = event;
        this.doubleClick = doubleClick;
        this.inputType = inputType;
        this.key = InputConstants.Type.MOUSE.getOrCreate(event.input());
    }

    @Override
    public InputConstants.Key getKey() {
        return this.key;
    }

    @Override
    public double getMouseX() {
        return this.event.x();
    }

    @Override
    public double getMouseY() {
        return this.event.y();
    }

    @Override
    public InputType getInputType() {
        return this.inputType;
    }

    @Override
    public int getModifiers() {
        return this.event.modifiers();
    }

    @Override
    public boolean isSimulate() {
        return this.inputType == InputType.SIMULATE;
    }

    @Override
    public boolean isAllowedChatCharacter() {
        return false;
    }

    @Override
    public Either<MouseButtonEvent, KeyEvent> getEvent() {
        return Either.left((Object)this.event);
    }

    @Override
    public boolean ifMouseEvent(UserInput.MouseClickable mouseClickable) {
        return mouseClickable.mouseClicked(this.event, this.doubleClick);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("inputType", (Object)this.inputType).add("key", (Object)KeyNameUtil.getKeyDisplayName(this.key).getString()).add("event", (Object)this.event).toString();
    }
}

