/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.api.runtime.IJeiKeyMapping;
import mezz.jei.common.platform.IPlatformInputHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.gui.input.InputType;
import mezz.jei.gui.input.KeyUserInput;
import mezz.jei.gui.input.MouseUserInput;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;

public abstract class UserInput
implements IJeiUserInput {
    public static UserInput fromVanilla(KeyEvent keyEvent, InputType inputType) {
        return new KeyUserInput(keyEvent, inputType);
    }

    public static Optional<UserInput> fromVanilla(MouseButtonEvent mouseButtonEvent, boolean doubleClick, InputType inputType) {
        int mouseButton = mouseButtonEvent.button();
        if (mouseButton < 0) {
            return Optional.empty();
        }
        MouseUserInput userInput = new MouseUserInput(mouseButtonEvent, doubleClick, inputType);
        return Optional.of(userInput);
    }

    public abstract double getMouseX();

    public abstract double getMouseY();

    public abstract InputType getInputType();

    public abstract boolean isAllowedChatCharacter();

    public final boolean is(IJeiKeyMapping keyMapping) {
        return keyMapping.isActiveAndMatches(this.getKey());
    }

    public final boolean is(KeyMapping keyMapping) {
        IPlatformInputHelper inputHelper = Services.PLATFORM.getInputHelper();
        return inputHelper.isActiveAndMatches(keyMapping, this.getKey(), this.getEvent());
    }

    public abstract Either<MouseButtonEvent, KeyEvent> getEvent();

    public abstract boolean ifMouseEvent(MouseClickable var1);

    @FunctionalInterface
    public static interface MouseClickable {
        public boolean mouseClicked(MouseButtonEvent var1, boolean var2);
    }
}

