/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.grindstone;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.recipe.vanilla.IJeiGrindstoneRecipe;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformRecipeHelper;
import mezz.jei.common.util.MathUtil;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.library.plugins.vanilla.grindstone.GrindstoneRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;

public final class GrindstoneRecipeMaker {
    private static GrindstoneMenu GRINDSTONE_MENU;
    private static final int TOP_SLOT = 0;
    private static final int BOTTOM_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;

    public static List<IJeiGrindstoneRecipe> getGrindstoneRecipes(IIngredientManager ingredientManager, IPlatformRecipeHelper platformHelper) {
        return Stream.concat(GrindstoneRecipeMaker.getRepairRecipes(ingredientManager), GrindstoneRecipeMaker.getDisenchantRecipes(ingredientManager, platformHelper)).toList();
    }

    private static Stream<IJeiGrindstoneRecipe> getDisenchantRecipes(IIngredientManager ingredientManager, IPlatformRecipeHelper platformHelper) {
        Registry registry = RegistryUtil.getRegistry(Registries.ENCHANTMENT);
        List enchantments = registry.listElements().toList();
        ArrayList<IJeiGrindstoneRecipe> grindstoneRecipes = new ArrayList<IJeiGrindstoneRecipe>();
        for (ItemStack stack : ingredientManager.getAllItemStacks()) {
            if (!stack.isEnchantable()) continue;
            for (Holder.Reference enchantmentHolder : enchantments) {
                Enchantment enchantment;
                if (enchantmentHolder.is(EnchantmentTags.CURSE) || !(enchantment = (Enchantment)enchantmentHolder.value()).isSupportedItem(stack) || !platformHelper.isItemEnchantable(stack, (Holder<Enchantment>)enchantmentHolder)) continue;
                Optional enchantmentResourceLocation = registry.getResourceKey((Object)enchantment);
                String enchantmentPath = enchantmentResourceLocation.map(enchantmentResourceKey -> enchantmentResourceKey.location().getPath()).orElse(null);
                for (int level = 1; level <= Math.min(enchantment.getMaxLevel(), 10); ++level) {
                    ItemStack enchantedStack = stack.copy();
                    enchantedStack.enchant((Holder)enchantmentHolder, level);
                    String itemId = stack.getItem().getDescriptionId();
                    ResourceLocation uid = enchantmentPath != null ? ResourceLocation.withDefaultNamespace((String)"grindstone.disenchantment.%s.%s.%d".formatted(itemId, enchantmentPath, level)) : null;
                    IJeiGrindstoneRecipe grindstoneRecipe = GrindstoneRecipeMaker.getGrindstoneRecipe(enchantedStack, ItemStack.EMPTY, uid);
                    if (grindstoneRecipe == null) continue;
                    grindstoneRecipes.add(grindstoneRecipe);
                }
            }
        }
        return grindstoneRecipes.stream();
    }

    private static Stream<IJeiGrindstoneRecipe> getRepairRecipes(IIngredientManager ingredientManager) {
        return ingredientManager.getAllItemStacks().stream().filter(ItemStack::isDamageableItem).map(stack -> {
            stack.setDamageValue(stack.getMaxDamage() * 3 / 4);
            ItemStack topInput = stack.copy();
            ItemStack bottomInput = stack.copy();
            String itemId = stack.getItem().getDescriptionId();
            return GrindstoneRecipeMaker.getGrindstoneRecipe(topInput, bottomInput, ResourceLocation.withDefaultNamespace((String)("grindstone.self_repair." + itemId)));
        }).filter(Objects::nonNull);
    }

    @Nullable
    private static IJeiGrindstoneRecipe getGrindstoneRecipe(ItemStack topInput, ItemStack bottomInput, @Nullable ResourceLocation uid) {
        GrindstoneMenu grindstoneMenu = GrindstoneRecipeMaker.getFakeGrindstoneMenu();
        if (grindstoneMenu == null) {
            return null;
        }
        ((Slot)grindstoneMenu.slots.get(0)).set(topInput);
        ((Slot)grindstoneMenu.slots.get(1)).set(topInput);
        ItemStack output = ((Slot)grindstoneMenu.slots.get(2)).getItem();
        if (output.isEmpty()) {
            return null;
        }
        int minXp = GrindstoneRecipeMaker.getMinXp(grindstoneMenu);
        int maxXp = minXp * 2;
        return new GrindstoneRecipe(List.of(topInput), List.of(bottomInput), List.of(output), minXp, maxXp, uid);
    }

    private static int getMinXp(GrindstoneMenu grindstoneMenu) {
        ItemStack topItem = ((Slot)grindstoneMenu.slots.get(0)).getItem();
        ItemStack bottomItem = ((Slot)grindstoneMenu.slots.get(1)).getItem();
        int topXp = GrindstoneRecipeMaker.getExperienceFromItem(topItem);
        int bottomXp = GrindstoneRecipeMaker.getExperienceFromItem(bottomItem);
        return MathUtil.divideCeil(topXp + bottomXp, 2);
    }

    private static int getExperienceFromItem(ItemStack stack) {
        int i = 0;
        ItemEnchantments itemEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
            Holder holder = (Holder)entry.getKey();
            int j = entry.getIntValue();
            if (holder.is(EnchantmentTags.CURSE)) continue;
            i += ((Enchantment)holder.value()).getMinCost(j);
        }
        return i;
    }

    @Nullable
    private static GrindstoneMenu getFakeGrindstoneMenu() {
        if (GRINDSTONE_MENU == null) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return null;
            }
            Inventory fakeInventory = new Inventory((Player)player, new EntityEquipment());
            GRINDSTONE_MENU = new GrindstoneMenu(0, fakeInventory);
            return GRINDSTONE_MENU;
        }
        return GRINDSTONE_MENU;
    }
}

