/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.startup;

import com.google.common.collect.ImmutableSetMultimap;
import java.nio.file.Path;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.Internal;
import mezz.jei.common.config.ConfigManager;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.config.JeiClientConfigs;
import mezz.jei.common.config.file.ConfigSchemaBuilder;
import mezz.jei.common.config.file.FileWatcher;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ChatUtil;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.common.util.Translator;
import mezz.jei.core.util.LoggedTimer;
import mezz.jei.library.color.ColorHelper;
import mezz.jei.library.config.ColorNameConfig;
import mezz.jei.library.config.EditModeConfig;
import mezz.jei.library.config.ModIdFormatConfig;
import mezz.jei.library.config.RecipeCategorySortingConfig;
import mezz.jei.library.focus.FocusFactory;
import mezz.jei.library.helpers.CodecHelper;
import mezz.jei.library.ingredients.subtypes.SubtypeManager;
import mezz.jei.library.load.PluginCaller;
import mezz.jei.library.load.PluginHelper;
import mezz.jei.library.load.PluginLoader;
import mezz.jei.library.load.registration.RuntimeRegistration;
import mezz.jei.library.plugins.jei.JeiInternalPlugin;
import mezz.jei.library.plugins.vanilla.VanillaPlugin;
import mezz.jei.library.recipes.RecipeManager;
import mezz.jei.library.runtime.JeiHelpers;
import mezz.jei.library.runtime.JeiRuntime;
import mezz.jei.library.startup.StartData;
import net.minecraft.class_10289;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class JeiStarter {
    private static final Logger LOGGER = LogManager.getLogger();
    private final StartData data;
    private final List<IModPlugin> plugins;
    private final VanillaPlugin vanillaPlugin;
    private final ModIdFormatConfig modIdFormatConfig;
    private final ColorNameConfig colorNameConfig;
    private final RecipeCategorySortingConfig recipeCategorySortingConfig;
    private final FileWatcher fileWatcher = new FileWatcher("JEI Config File Watcher");
    private final ConfigManager configManager;
    private final JeiClientConfigs jeiClientConfigs;

    public JeiStarter(StartData data) {
        ErrorUtil.checkNotEmpty(data.plugins(), "plugins");
        this.data = data;
        this.plugins = data.plugins();
        this.vanillaPlugin = PluginHelper.getPluginWithClass(VanillaPlugin.class, this.plugins).orElseThrow(() -> new IllegalStateException("vanilla plugin not found"));
        JeiInternalPlugin jeiInternalPlugin = PluginHelper.getPluginWithClass(JeiInternalPlugin.class, this.plugins).orElse(null);
        PluginHelper.sortPlugins(this.plugins, this.vanillaPlugin, jeiInternalPlugin);
        Path configDir = Services.PLATFORM.getConfigHelper().createJeiConfigDir();
        this.configManager = new ConfigManager();
        ConfigSchemaBuilder debugFileBuilder = new ConfigSchemaBuilder(configDir.resolve("jei-debug.ini"), "jei.config.debug");
        DebugConfig.create(debugFileBuilder);
        debugFileBuilder.build().register(this.fileWatcher, this.configManager);
        ConfigSchemaBuilder modFileBuilder = new ConfigSchemaBuilder(configDir.resolve("jei-mod-id-format.ini"), "jei.config.modIdFormat");
        this.modIdFormatConfig = new ModIdFormatConfig(modFileBuilder);
        modFileBuilder.build().register(this.fileWatcher, this.configManager);
        ConfigSchemaBuilder colorFileBuilder = new ConfigSchemaBuilder(configDir.resolve("jei-colors.ini"), "jei.config.colors");
        this.colorNameConfig = new ColorNameConfig(colorFileBuilder);
        colorFileBuilder.build().register(this.fileWatcher, this.configManager);
        this.jeiClientConfigs = new JeiClientConfigs(configDir.resolve("jei-client.ini"));
        this.jeiClientConfigs.register(this.fileWatcher, this.configManager);
        Internal.setJeiClientConfigs(this.jeiClientConfigs);
        this.fileWatcher.start();
        this.recipeCategorySortingConfig = new RecipeCategorySortingConfig(configDir.resolve("recipe-category-sort-order.ini"));
        PluginCaller.callOnPlugins("Sending ConfigManager", this.plugins, p -> p.onConfigManagerAvailable(this.configManager));
    }

    public void start() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 == null) {
            LOGGER.error("Failed to start JEI, there is no Minecraft client level.");
            return;
        }
        class_5455 registryAccess = minecraft.field_1687.method_30349();
        RegistryUtil.setRegistryAccess(registryAccess);
        LoggedTimer totalTime = new LoggedTimer();
        totalTime.start("Starting JEI");
        this.configManager.onJeiStarted();
        ColorHelper colorHelper = new ColorHelper(this.colorNameConfig);
        IIngredientFilterConfig ingredientFilterConfig = this.jeiClientConfigs.getIngredientFilterConfig();
        SubtypeManager subtypeManager = PluginLoader.registerSubtypes(this.data);
        IIngredientManager ingredientManager = PluginLoader.registerIngredients(this.data, subtypeManager, colorHelper, ingredientFilterConfig);
        FocusFactory focusFactory = new FocusFactory(ingredientManager);
        CodecHelper codecHelper = new CodecHelper(ingredientManager, focusFactory);
        Path configDir = Services.PLATFORM.getConfigHelper().createJeiConfigDir();
        EditModeConfig.FileSerializer editModeSerializer = new EditModeConfig.FileSerializer(configDir.resolve("blacklist.json"), registryAccess, codecHelper);
        EditModeConfig editModeConfig = new EditModeConfig(editModeSerializer, ingredientManager);
        ImmutableSetMultimap<String, String> modAliases = PluginLoader.registerModAliases(this.data, ingredientFilterConfig);
        JeiHelpers jeiHelpers = PluginLoader.createJeiHelpers(modAliases, this.modIdFormatConfig, colorHelper, editModeConfig, focusFactory, codecHelper, ingredientManager, subtypeManager);
        RecipeManager recipeManager = PluginLoader.createRecipeManager(this.plugins, this.vanillaPlugin, this.recipeCategorySortingConfig, jeiHelpers, ingredientManager);
        IRecipeTransferManager recipeTransferManager = PluginLoader.createRecipeTransferManager(this.vanillaPlugin, this.plugins, jeiHelpers, this.data.serverConnection());
        LoggedTimer timer = new LoggedTimer();
        timer.start("Building runtime");
        IScreenHelper screenHelper = PluginLoader.createGuiScreenHelper(this.plugins, jeiHelpers, ingredientManager);
        RuntimeRegistration runtimeRegistration = new RuntimeRegistration(recipeManager, jeiHelpers, editModeConfig, ingredientManager, recipeTransferManager, screenHelper);
        PluginCaller.callOnPlugins("Registering Runtime", this.plugins, p -> p.registerRuntime(runtimeRegistration));
        JeiRuntime jeiRuntime = new JeiRuntime(recipeManager, ingredientManager, Internal.getKeyMappings(), jeiHelpers, screenHelper, recipeTransferManager, editModeConfig, runtimeRegistration.getIngredientListOverlay(), runtimeRegistration.getBookmarkOverlay(), runtimeRegistration.getRecipesGui(), runtimeRegistration.getIngredientFilter(), this.configManager);
        timer.stop();
        PluginCaller.callOnPlugins("Sending Runtime", this.plugins, p -> p.onRuntimeAvailable(jeiRuntime));
        Internal.setRuntime(jeiRuntime);
        totalTime.stop();
        class_10289 clientSyncedRecipes = Internal.getClientSyncedRecipes();
        if (clientSyncedRecipes.method_64695().isEmpty()) {
            String message = Translator.translateToLocal("jei.message.missing.recipes.from.server");
            class_746 player = minecraft.field_1724;
            if (player != null) {
                ChatUtil.writeChatMessage((class_1657)player, message, class_124.field_1061);
            }
            LOGGER.error(message);
        }
    }

    public void stop() {
        LOGGER.info("Stopping JEI");
        List<IModPlugin> plugins = this.data.plugins();
        PluginCaller.callOnPlugins("Sending Runtime Unavailable", plugins, IModPlugin::onRuntimeUnavailable);
        Internal.setRuntime(null);
        RegistryUtil.setRegistryAccess(null);
    }
}

