package mezz.jei.common.network.packets;

import com.google.common.base.Preconditions;
import mezz.jei.api.constants.ModIds;
import mezz.jei.common.network.ServerPacketContext;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.ServerCommandUtil;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class PacketSetHotbarItemStack extends PlayToServerPacket<PacketSetHotbarItemStack> {
	public static final class_8710.class_9154<PacketSetHotbarItemStack> TYPE = new class_8710.class_9154<>(class_2960.method_60655(ModIds.JEI_ID, "set_hotbar_item_stack"));
	public static final class_9139<class_9129, PacketSetHotbarItemStack> STREAM_CODEC = class_9139.method_56435(
		class_1799.field_48349,
		p -> p.itemStack,
		class_9135.field_48550,
		p -> p.hotbarSlot,
		PacketSetHotbarItemStack::new
	);

	private final class_1799 itemStack;
	private final int hotbarSlot;

	public PacketSetHotbarItemStack(class_1799 itemStack, int hotbarSlot) {
		ErrorUtil.checkNotNull(itemStack, "itemStack");
		Preconditions.checkArgument(class_1661.method_7380(hotbarSlot), "hotbar slot must be in the hotbar. got: " + hotbarSlot);
		this.itemStack = itemStack;
		this.hotbarSlot = hotbarSlot;
	}

	@Override
	public void process(ServerPacketContext context) {
		ServerCommandUtil.setHotbarSlot(context, itemStack, hotbarSlot);
	}

	@Override
	public class_9154<PacketSetHotbarItemStack> method_56479() {
		return TYPE;
	}

	@Override
	public class_9139<class_9129, PacketSetHotbarItemStack> streamCodec() {
		return STREAM_CODEC;
	}
}
