/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.elements;

import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.placement.IPlaceable;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.client.gui.GuiGraphics;

public class OffsetDrawable
implements IDrawable,
IPlaceable<OffsetDrawable> {
    private final IDrawable drawable;
    private int xOffset;
    private int yOffset;

    public static IDrawable create(IDrawable drawable, int xOffset, int yOffset) {
        if (xOffset == 0 && yOffset == 0) {
            return drawable;
        }
        return new OffsetDrawable(drawable, xOffset, yOffset);
    }

    public OffsetDrawable(IDrawable drawable, int xOffset, int yOffset) {
        this.drawable = drawable;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public int getWidth() {
        return this.drawable.getWidth();
    }

    public int getHeight() {
        return this.drawable.getHeight();
    }

    public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        this.drawable.draw(guiGraphics, this.xOffset + xOffset, this.yOffset + yOffset);
    }

    public void draw(GuiGraphics guiGraphics) {
        this.drawable.draw(guiGraphics, this.xOffset, this.yOffset);
    }

    public OffsetDrawable setPosition(int xPos, int yPos) {
        this.xOffset = xPos;
        this.yOffset = yPos;
        return this;
    }

    public ImmutableRect2i getArea() {
        return new ImmutableRect2i(this.xOffset, this.yOffset, this.getWidth(), this.getHeight());
    }
}

