/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.debug;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.runtime.IBookmarkOverlay;
import mezz.jei.api.runtime.IIngredientFilter;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.library.plugins.debug.DebugRecipe;
import mezz.jei.library.plugins.debug.ingredients.DebugIngredient;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jspecify.annotations.Nullable;

public class DebugRecipeCategory<F>
implements IRecipeCategory<DebugRecipe> {
    public static final IRecipeType<DebugRecipe> TYPE = IRecipeType.create("jei", "debug", DebugRecipe.class);
    public static final int RECIPE_WIDTH = 160;
    public static final int RECIPE_HEIGHT = 60;
    private final IPlatformFluidHelper<F> platformFluidHelper;
    private final IIngredientManager ingredientManager;
    private final Component localizedName;
    private final IDrawable tankBackground;
    private final IDrawable tankOverlay;
    private final IDrawable item;
    private @Nullable IJeiRuntime runtime;
    private boolean hiddenRecipes;

    public DebugRecipeCategory(IGuiHelper guiHelper, IPlatformFluidHelper<F> platformFluidHelper, IIngredientManager ingredientManager) {
        this.platformFluidHelper = platformFluidHelper;
        this.ingredientManager = ingredientManager;
        this.localizedName = Component.literal((String)"debug");
        Identifier backgroundTexture = Identifier.fromNamespaceAndPath((String)"jei", (String)"textures/jei/gui/debug.png");
        this.tankBackground = guiHelper.createDrawable(backgroundTexture, 220, 196, 18, 60);
        this.tankOverlay = guiHelper.createDrawable(backgroundTexture, 238, 196, 18, 60);
        this.item = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)Items.ACACIA_LEAVES));
    }

    public void setRuntime(IJeiRuntime runtime) {
        this.runtime = runtime;
    }

    @Override
    public IRecipeType<DebugRecipe> getRecipeType() {
        return TYPE;
    }

    @Override
    public Component getTitle() {
        return this.localizedName;
    }

    @Override
    public int getWidth() {
        return 160;
    }

    @Override
    public int getHeight() {
        return 60;
    }

    @Override
    public IDrawable getIcon() {
        Textures textures = Internal.getTextures();
        return textures.getConfigButtonIcon();
    }

    @Override
    public void draw(DebugRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (this.runtime != null) {
            this.item.draw(guiGraphics, 50, 20);
            IIngredientFilter ingredientFilter = this.runtime.getIngredientFilter();
            Minecraft minecraft = Minecraft.getInstance();
            guiGraphics.drawString(minecraft.font, ingredientFilter.getFilterText(), 20, 52, 0, false);
            IIngredientListOverlay ingredientListOverlay = this.runtime.getIngredientListOverlay();
            Optional<ITypedIngredient<?>> ingredientUnderMouse = DebugRecipeCategory.getIngredientUnderMouse(ingredientListOverlay, this.runtime.getBookmarkOverlay());
            ingredientUnderMouse.ifPresent(typedIngredient -> this.drawIngredientName(minecraft, guiGraphics, (ITypedIngredient)typedIngredient));
        }
        Button button = recipe.getButton();
        button.render(guiGraphics, (int)mouseX, (int)mouseY, 0.0f);
    }

    private static Optional<ITypedIngredient<?>> getIngredientUnderMouse(IIngredientListOverlay ingredientListOverlay, IBookmarkOverlay bookmarkOverlay) {
        return ingredientListOverlay.getIngredientUnderMouse().or(bookmarkOverlay::getIngredientUnderMouse);
    }

    private <T> void drawIngredientName(Minecraft minecraft, GuiGraphics guiGraphics, ITypedIngredient<T> ingredient) {
        IIngredientHelper<T> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredient.getType());
        String serialized = ingredientHelper.getIdentifier(ingredient.getIngredient()).toString();
        guiGraphics.drawString(minecraft.font, serialized, 50, 52, 0, false);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, DebugRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addOutputSlot(70, 0).add(new ItemStack((ItemLike)Items.FARMLAND))).add(new ItemStack((ItemLike)Items.BUNDLE));
        builder.addInputSlot(110, 0).addIngredientsUnsafe(Arrays.asList(new ItemStack((ItemLike)Items.RABBIT), null));
        long bucketVolume = this.platformFluidHelper.bucketVolume();
        IIngredientTypeWithSubtypes<Fluid, F> fluidType = this.platformFluidHelper.getFluidIngredientType();
        long capacity = 10L * bucketVolume;
        long amount = capacity / 2L + (long)((int)(Math.random() * (double)capacity / 2.0));
        builder.addOutputSlot(90, 0).setFluidRenderer(capacity, false, 16, 58).setOverlay(this.tankOverlay, -1, -1).setBackground(this.tankBackground, -1, -1).add((Fluid)Fluids.WATER, amount);
        capacity = 2L * bucketVolume;
        amount = capacity / 2L + (long)((int)(Math.random() * (double)capacity / 2.0));
        builder.addInputSlot(24, 0).setFluidRenderer(capacity, true, 12, 47).add(fluidType, this.platformFluidHelper.create((Holder<Fluid>)Fluids.LAVA.defaultFluidState().holder(), amount));
        builder.addInputSlot(40, 0).addIngredients(DebugIngredient.TYPE, List.of(new DebugIngredient(0), new DebugIngredient(1)));
        builder.addOutputSlot(40, 16).add(DebugIngredient.TYPE, new DebugIngredient(2));
        ((IRecipeSlotBuilder)((IRecipeSlotBuilder)builder.addInputSlot(40, 32).add(DebugIngredient.TYPE, new DebugIngredient(3))).addIngredientsUnsafe(List.of(this.platformFluidHelper.create((Holder<Fluid>)Fluids.LAVA.defaultFluidState().holder(), (int)((1.0 + Math.random()) * (double)bucketVolume)), new ItemStack((ItemLike)Items.ACACIA_LEAVES)))).addRichTooltipCallback((recipeSlotView, tooltip) -> {
            switch (recipeSlotView.getRole()) {
                case INPUT: {
                    tooltip.add((FormattedText)Component.literal((String)"Input DebugIngredient"));
                    break;
                }
                case OUTPUT: {
                    tooltip.add((FormattedText)Component.literal((String)"Output DebugIngredient"));
                    break;
                }
                case CRAFTING_STATION: {
                    tooltip.add((FormattedText)Component.literal((String)"Crafting Station DebugIngredient"));
                }
            }
        });
    }

    @Override
    public void createRecipeExtras(IRecipeExtrasBuilder builder, DebugRecipe recipe, IFocusGroup focuses) {
        builder.addInputHandler(new JeiInputHandler(recipe, new ScreenRectangle(0, 0, 160, 60)));
    }

    @Override
    public void getTooltip(ITooltipBuilder tooltip, DebugRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        tooltip.add((FormattedText)Component.literal((String)"Debug Recipe Category Tooltip is very long and going to wrap").withStyle(ChatFormatting.GOLD));
        if (recipe.checkHover(mouseX, mouseY)) {
            tooltip.add((FormattedText)Component.literal((String)"button tooltip!"));
        } else {
            MutableComponent debug = Component.literal((String)"tooltip debug");
            tooltip.add((FormattedText)debug.withStyle(ChatFormatting.BOLD));
        }
        tooltip.add((FormattedText)Component.literal((String)(mouseX + ", " + mouseY)));
    }

    @Override
    public Identifier getIdentifier(DebugRecipe recipe) {
        return recipe.getId();
    }

    @Override
    public boolean needsRecipeBorder() {
        return false;
    }

    public class JeiInputHandler
    implements IJeiInputHandler {
        private final DebugRecipe recipe;
        private final ScreenRectangle area;

        public JeiInputHandler(DebugRecipe recipe, ScreenRectangle area) {
            this.recipe = recipe;
            this.area = area;
        }

        @Override
        public ScreenRectangle getArea() {
            return this.area;
        }

        @Override
        public boolean handleInput(double mouseX, double mouseY, IJeiUserInput userInput) {
            if (!userInput.is(Internal.getKeyMappings().getLeftClick())) {
                return false;
            }
            InputConstants.Key key = userInput.getKey();
            Button button = this.recipe.getButton();
            int mouseButton = key.getValue();
            int modifiers = userInput.getModifiers();
            MouseButtonInfo buttonInfo = new MouseButtonInfo(mouseButton, modifiers);
            MouseButtonEvent mouseButtonEvent = new MouseButtonEvent(mouseX, mouseY, buttonInfo);
            if (mouseButton == 0 && button.mouseClicked(mouseButtonEvent, false)) {
                if (!userInput.isSimulate()) {
                    Minecraft minecraft = Minecraft.getInstance();
                    LocalPlayer player = minecraft.player;
                    if (player != null) {
                        InventoryScreen screen = new InventoryScreen((Player)player);
                        minecraft.setScreen((Screen)screen);
                    }
                    if (DebugRecipeCategory.this.runtime != null) {
                        IIngredientFilter ingredientFilter = DebugRecipeCategory.this.runtime.getIngredientFilter();
                        String filterText = ingredientFilter.getFilterText();
                        ingredientFilter.setFilterText(filterText + " test");
                        IRecipeManager recipeManager = DebugRecipeCategory.this.runtime.getRecipeManager();
                        if (!DebugRecipeCategory.this.hiddenRecipes) {
                            recipeManager.hideRecipeCategory(RecipeTypes.CRAFTING);
                            DebugRecipeCategory.this.hiddenRecipes = true;
                        } else {
                            recipeManager.unhideRecipeCategory(RecipeTypes.CRAFTING);
                            DebugRecipeCategory.this.hiddenRecipes = false;
                        }
                    }
                }
                return true;
            }
            return false;
        }
    }
}

