/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.recipes.supplier.builder;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.library.ingredients.SimpleIngredientAcceptor;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import org.jspecify.annotations.Nullable;

public class IngredientSlotBuilder
implements IRecipeSlotBuilder {
    private final SimpleIngredientAcceptor ingredients;

    public IngredientSlotBuilder(IIngredientManager ingredientManager) {
        this.ingredients = new SimpleIngredientAcceptor(ingredientManager);
    }

    public IRecipeSlotBuilder add(SlotDisplay slotDisplay) {
        this.ingredients.add(slotDisplay);
        return this;
    }

    public IRecipeSlotBuilder add(ItemStack itemStack) {
        this.ingredients.add(itemStack);
        return this;
    }

    public IRecipeSlotBuilder add(ItemLike itemLike) {
        this.ingredients.add(itemLike);
        return this;
    }

    public IRecipeSlotBuilder add(Fluid fluid) {
        this.ingredients.add(fluid);
        return this;
    }

    public IRecipeSlotBuilder add(Fluid fluid, long amount) {
        this.ingredients.add(fluid, amount);
        return this;
    }

    public IRecipeSlotBuilder add(Fluid fluid, long amount, DataComponentPatch component) {
        this.ingredients.add(fluid, amount, component);
        return this;
    }

    public IRecipeSlotBuilder add(Ingredient ingredient) {
        this.ingredients.add(ingredient);
        return this;
    }

    public <I> IRecipeSlotBuilder add(ITypedIngredient<I> typedIngredient) {
        this.ingredients.add((ITypedIngredient)typedIngredient);
        return this;
    }

    public <I> IRecipeSlotBuilder add(IIngredientType<I> ingredientType, I ingredient) {
        this.ingredients.add((IIngredientType)ingredientType, ingredient);
        return this;
    }

    public <I> IRecipeSlotBuilder addIngredients(IIngredientType<I> ingredientType, List<@Nullable I> ingredients) {
        this.ingredients.addIngredients((IIngredientType)ingredientType, ingredients);
        return this;
    }

    public <I> IRecipeSlotBuilder addIngredient(IIngredientType<I> ingredientType, I ingredient) {
        this.ingredients.add((IIngredientType)ingredientType, ingredient);
        return this;
    }

    public IRecipeSlotBuilder addIngredientsUnsafe(List<?> ingredients) {
        this.ingredients.addIngredientsUnsafe((List)ingredients);
        return this;
    }

    public IRecipeSlotBuilder addTypedIngredients(List<ITypedIngredient<?>> ingredients) {
        this.ingredients.addTypedIngredients((List)ingredients);
        return this;
    }

    public IRecipeSlotBuilder addOptionalTypedIngredients(List<Optional<ITypedIngredient<?>>> ingredients) {
        this.ingredients.addOptionalTypedIngredients((List)ingredients);
        return this;
    }

    public IRecipeSlotBuilder addItemStacks(List<ItemStack> itemStacks) {
        return (IRecipeSlotBuilder)super.addItemStacks(itemStacks);
    }

    public IRecipeSlotBuilder setStandardSlotBackground() {
        return this;
    }

    public IRecipeSlotBuilder setOutputSlotBackground() {
        return this;
    }

    public IRecipeSlotBuilder setBackground(IDrawable background, int xOffset, int yOffset) {
        return this;
    }

    public IRecipeSlotBuilder setOverlay(IDrawable overlay, int xOffset, int yOffset) {
        return this;
    }

    public IRecipeSlotBuilder setFluidRenderer(long capacity, boolean showCapacity, int width, int height) {
        return this;
    }

    public <T> IRecipeSlotBuilder setCustomRenderer(IIngredientType<T> ingredientType, IIngredientRenderer<T> ingredientRenderer) {
        return this;
    }

    public IRecipeSlotBuilder addRichTooltipCallback(IRecipeSlotRichTooltipCallback tooltipCallback) {
        return this;
    }

    public IRecipeSlotBuilder setSlotName(String slotName) {
        return this;
    }

    public int getWidth() {
        return 16;
    }

    public int getHeight() {
        return 16;
    }

    public IRecipeSlotBuilder setPosition(int xPos, int yPos) {
        return this;
    }

    public IRecipeSlotBuilder setPosition(int areaX, int areaY, int areaWidth, int areaHeight, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        return this;
    }

    public List<ITypedIngredient<?>> getAllIngredients() {
        return this.ingredients.getAllIngredients();
    }
}

