/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.ingredients;

import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.constants.Tags;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IJeiClientConfigs;
import mezz.jei.common.platform.IPlatformItemStackHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.common.util.StackHelper;
import mezz.jei.common.util.TagUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class ItemStackHelper
implements IIngredientHelper<ItemStack> {
    private final StackHelper stackHelper;
    private final IColorHelper colorHelper;
    private final TagKey<Item> itemHiddenFromRecipeViewers;
    private final TagKey<Block> blockHiddenFromRecipeViewers;

    public ItemStackHelper(StackHelper stackHelper, IColorHelper colorHelper) {
        this.stackHelper = stackHelper;
        this.colorHelper = colorHelper;
        this.itemHiddenFromRecipeViewers = TagKey.create((ResourceKey)Registries.ITEM, (Identifier)Tags.HIDDEN_FROM_RECIPE_VIEWERS);
        this.blockHiddenFromRecipeViewers = TagKey.create((ResourceKey)Registries.BLOCK, (Identifier)Tags.HIDDEN_FROM_RECIPE_VIEWERS);
    }

    public IIngredientType<ItemStack> getIngredientType() {
        return VanillaTypes.ITEM_STACK;
    }

    public String getDisplayName(ItemStack ingredient) {
        Component displayNameTextComponent = ingredient.getHoverName();
        String displayName = displayNameTextComponent.getString();
        ErrorUtil.checkNotNull((Object)displayName, (String)"itemStack.getDisplayName()");
        return displayName;
    }

    public Object getUid(ItemStack ingredient, UidContext context) {
        ErrorUtil.checkNotNull((Object)ingredient, (String)"ingredient");
        ErrorUtil.checkNotNull((Object)context, (String)"type");
        return this.stackHelper.getUidForStack(ingredient, context);
    }

    public Object getUid(ITypedIngredient<ItemStack> typedIngredient, UidContext context) {
        ErrorUtil.checkNotNull(typedIngredient, (String)"typedIngredient");
        ErrorUtil.checkNotNull((Object)context, (String)"type");
        return this.stackHelper.getUidForStack(typedIngredient, context);
    }

    public Object getGroupingUid(ITypedIngredient<ItemStack> typedIngredient) {
        return typedIngredient.getBaseIngredient(VanillaTypes.ITEM_STACK);
    }

    public Object getGroupingUid(ItemStack ingredient) {
        return ingredient.getItem();
    }

    public boolean hasSubtypes(ItemStack ingredient) {
        ErrorUtil.checkNotNull((Object)ingredient, (String)"ingredient");
        return this.stackHelper.hasSubtypes(ingredient);
    }

    public String getDisplayModId(ItemStack ingredient) {
        ErrorUtil.checkNotNull((Object)ingredient, (String)"ingredient");
        IPlatformItemStackHelper itemStackHelper = Services.PLATFORM.getItemStackHelper();
        return (String)itemStackHelper.getCreatorModId(ingredient).or(() -> ItemStackHelper.getNamespace(ingredient)).orElseThrow(() -> {
            String stackInfo = this.getErrorInfo(ingredient);
            return new IllegalStateException("null registryName for: " + stackInfo);
        });
    }

    private static Optional<String> getNamespace(ItemStack ingredient) {
        Identifier key = RegistryUtil.getRegistry((ResourceKey)Registries.ITEM).getKey((Object)ingredient.getItem());
        return Optional.ofNullable(key).map(Identifier::getNamespace);
    }

    public long getAmount(ItemStack ingredient) {
        return ingredient.getCount();
    }

    public ItemStack copyWithAmount(ItemStack ingredient, long amount) {
        ItemStack copy = ingredient.copy();
        int intAmount = Math.toIntExact(amount);
        copy.setCount(intAmount);
        return copy;
    }

    public Iterable<Integer> getColors(ItemStack ingredient) {
        return this.colorHelper.getColors(ingredient, 2);
    }

    public Identifier getIdentifier(ItemStack ingredient) {
        ErrorUtil.checkNotNull((Object)ingredient, (String)"ingredient");
        Item item = ingredient.getItem();
        Identifier key = RegistryUtil.getRegistry((ResourceKey)Registries.ITEM).getKey((Object)item);
        if (key == null) {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("item has no key in the Item registry: " + stackInfo);
        }
        return key;
    }

    public ItemStack getCheatItemStack(ItemStack ingredient) {
        return ingredient;
    }

    public ItemStack copyIngredient(ItemStack ingredient) {
        return ingredient.copy();
    }

    public ItemStack normalizeIngredient(ItemStack ingredient) {
        if (ingredient.getCount() == 1) {
            return ingredient;
        }
        int originalCount = ingredient.getCount();
        ingredient.setCount(1);
        ItemStack copy = ingredient.copy();
        ingredient.setCount(originalCount);
        return copy;
    }

    public boolean isValidIngredient(ItemStack ingredient) {
        return !ingredient.isEmpty();
    }

    public boolean isIngredientOnServer(ItemStack ingredient) {
        Item item = ingredient.getItem();
        Registry registry = RegistryUtil.getRegistry((ResourceKey)Registries.ITEM);
        return registry.getKey((Object)item) != null;
    }

    public Stream<Identifier> getTagStream(ItemStack ingredient) {
        Stream<Identifier> itemTagStream = ingredient.getTags().map(TagKey::location);
        Item item = ingredient.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            IJeiClientConfigs jeiClientConfigs = Internal.getJeiClientConfigs();
            IClientConfig clientConfig = jeiClientConfigs.getClientConfig();
            if (clientConfig.isLookupBlockTagsEnabled()) {
                Stream<Identifier> blockTagStream = blockItem.getBlock().defaultBlockState().getTags().map(TagKey::location);
                return Streams.concat((Stream[])new Stream[]{itemTagStream, blockTagStream});
            }
        }
        return itemTagStream;
    }

    public boolean isHiddenFromRecipeViewersByTags(ItemStack ingredient) {
        return this.isHiddenFromRecipeViewersByTags((Holder<Item>)ingredient.getItemHolder());
    }

    public boolean isHiddenFromRecipeViewersByTags(ITypedIngredient<ItemStack> ingredient) {
        Item item = (Item)ingredient.getBaseIngredient(VanillaTypes.ITEM_STACK);
        Holder.Reference itemHolder = item.builtInRegistryHolder();
        return this.isHiddenFromRecipeViewersByTags((Holder<Item>)itemHolder);
    }

    private boolean isHiddenFromRecipeViewersByTags(Holder<Item> itemHolder) {
        if (itemHolder.is(this.itemHiddenFromRecipeViewers)) {
            return true;
        }
        Object object = itemHolder.value();
        if (object instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)object;
            IJeiClientConfigs jeiClientConfigs = Internal.getJeiClientConfigs();
            IClientConfig clientConfig = jeiClientConfigs.getClientConfig();
            if (clientConfig.isLookupBlockTagsEnabled()) {
                Block block = blockItem.getBlock();
                Holder.Reference blockHolder = block.builtInRegistryHolder();
                return blockHolder.is(this.blockHiddenFromRecipeViewers);
            }
        }
        return false;
    }

    public String getErrorInfo(@Nullable ItemStack ingredient) {
        return ErrorUtil.getItemStackInfo((ItemStack)ingredient);
    }

    public Optional<TagKey<?>> getTagKeyEquivalent(Collection<ItemStack> ingredients) {
        Registry itemRegistry = RegistryUtil.getRegistry((ResourceKey)Registries.ITEM);
        return TagUtil.getTagEquivalent(ingredients, ItemStack::getItem, () -> ((Registry)itemRegistry).getTags());
    }
}

