/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.debug;

import java.util.List;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.library.plugins.debug.DebugRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class DebugFocusRecipeCategory<F>
implements IRecipeCategory<DebugRecipe> {
    public static final IRecipeType<DebugRecipe> TYPE = IRecipeType.create((String)"jei", (String)"debug_focus", DebugRecipe.class);
    public static final int RECIPE_WIDTH = 160;
    public static final int RECIPE_HEIGHT = 60;
    private final IPlatformFluidHelper<F> platformFluidHelper;
    private final Component localizedName;

    public DebugFocusRecipeCategory(IPlatformFluidHelper<F> platformFluidHelper) {
        this.platformFluidHelper = platformFluidHelper;
        this.localizedName = Component.literal((String)"debug_focus");
    }

    public IRecipeType<DebugRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public int getWidth() {
        return 160;
    }

    public int getHeight() {
        return 60;
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DebugRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder inputSlot = (IRecipeSlotBuilder)builder.addInputSlot(0, 0).addItemStacks(List.of(new ItemStack((ItemLike)Items.BUCKET), new ItemStack((ItemLike)Items.WATER_BUCKET), new ItemStack((ItemLike)Items.LAVA_BUCKET), new ItemStack((ItemLike)Items.POWDER_SNOW_BUCKET), new ItemStack((ItemLike)Items.AXOLOTL_BUCKET), new ItemStack((ItemLike)Items.SALMON_BUCKET), new ItemStack((ItemLike)Items.COD_BUCKET), new ItemStack((ItemLike)Items.PUFFERFISH_BUCKET), new ItemStack((ItemLike)Items.TROPICAL_FISH_BUCKET)));
        long bucketVolume = this.platformFluidHelper.bucketVolume();
        IRecipeSlotBuilder outputSlot = (IRecipeSlotBuilder)((IRecipeSlotBuilder)((IRecipeSlotBuilder)builder.addOutputSlot(20, 0).add(ItemStack.EMPTY)).addIngredients((IIngredientType)this.platformFluidHelper.getFluidIngredientType(), List.of(this.platformFluidHelper.create(Fluids.WATER.defaultFluidState().holder(), bucketVolume), this.platformFluidHelper.create(Fluids.LAVA.defaultFluidState().holder(), bucketVolume)))).addItemStacks(List.of(new ItemStack((ItemLike)Items.SNOW_BLOCK), new ItemStack((ItemLike)Items.AXOLOTL_SPAWN_EGG), new ItemStack((ItemLike)Items.SALMON), new ItemStack((ItemLike)Items.COD), new ItemStack((ItemLike)Items.PUFFERFISH), new ItemStack((ItemLike)Items.TROPICAL_FISH)));
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(List.of(new ItemStack((ItemLike)Items.ACACIA_BOAT), new ItemStack((ItemLike)Items.ACACIA_BUTTON), new ItemStack((ItemLike)Items.ACACIA_DOOR), new ItemStack((ItemLike)Items.ACACIA_LOG), new ItemStack((ItemLike)Items.ACACIA_PLANKS), new ItemStack((ItemLike)Items.ACACIA_FENCE), new ItemStack((ItemLike)Items.ACACIA_FENCE_GATE), new ItemStack((ItemLike)Items.ACACIA_LEAVES), new ItemStack((ItemLike)Items.ACACIA_PRESSURE_PLATE)));
        builder.createFocusLink(new IIngredientAcceptor[]{inputSlot, outputSlot});
    }

    public Identifier getIdentifier(DebugRecipe recipe) {
        return recipe.getId();
    }
}

