/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks.history;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.config.ILookupHistoryConfig;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.gui.overlay.elements.IElement;
import net.minecraft.core.RegistryAccess;
import org.jetbrains.annotations.Unmodifiable;

public class LookupHistory
implements IIngredientGridSource {
    private final List<IBookmark> elements = new LinkedList<IBookmark>();
    private final List<IIngredientGridSource.SourceListChangedListener> listeners = new ArrayList<IIngredientGridSource.SourceListChangedListener>();
    private final IRecipeManager recipeManager;
    private final IIngredientManager ingredientManager;
    private final RegistryAccess registryAccess;
    private final ICodecHelper codecHelper;
    private final Supplier<Integer> maxElements;
    private final ILookupHistoryConfig lookupHistoryConfig;

    public LookupHistory(IRecipeManager recipeManager, IIngredientManager ingredientManager, RegistryAccess registryAccess, ICodecHelper codecHelper, Supplier<Integer> maxElements, ILookupHistoryConfig lookupHistoryConfig) {
        this.recipeManager = recipeManager;
        this.ingredientManager = ingredientManager;
        this.registryAccess = registryAccess;
        this.codecHelper = codecHelper;
        this.maxElements = maxElements;
        this.lookupHistoryConfig = lookupHistoryConfig;
        List<IBookmark> loaded = lookupHistoryConfig.load(recipeManager, ingredientManager, registryAccess, codecHelper);
        this.elements.addAll(loaded);
    }

    public void add(IBookmark element) {
        this.elements.remove(element);
        this.elements.addFirst(element);
        if (this.elements.size() > this.maxElements.get()) {
            this.elements.removeLast();
        }
        this.notifyListeners();
        this.lookupHistoryConfig.save(this.recipeManager, this.ingredientManager, this.registryAccess, this.codecHelper, this.elements);
    }

    @Override
    public @Unmodifiable List<IElement<?>> getElements() {
        return this.elements.stream().map(IBookmark::getElement).toList();
    }

    @Override
    public void addSourceListChangedListener(IIngredientGridSource.SourceListChangedListener listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners() {
        for (IIngredientGridSource.SourceListChangedListener listener : this.listeners) {
            listener.onSourceListChanged();
        }
    }
}

