/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.buttons.IButtonState;
import mezz.jei.api.gui.buttons.IIconButtonController;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import mezz.jei.common.transfer.RecipeTransferUtil;
import mezz.jei.gui.recipes.RecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class RecipeTransferButtonController
implements IIconButtonController {
    private final IRecipeLayoutDrawable<?> recipeLayout;
    private final RecipesGui recipesGui;
    @Nullable
    private IRecipeTransferError recipeTransferError;

    public RecipeTransferButtonController(IRecipeLayoutDrawable<?> recipeLayout, RecipesGui recipesGui) {
        this.recipeLayout = recipeLayout;
        this.recipesGui = recipesGui;
    }

    public void initState(IButtonState state) {
        Textures textures = Internal.getTextures();
        state.setIcon((IDrawable)textures.getRecipeTransfer());
        this.updateState(state);
    }

    public void updateState(IButtonState state) {
        LocalPlayer player = Minecraft.getInstance().player;
        AbstractContainerMenu parentContainer = this.recipesGui.getParentContainerMenu();
        if (parentContainer != null && player != null) {
            IRecipeTransferManager recipeTransferManager = Internal.getJeiRuntime().getRecipeTransferManager();
            this.recipeTransferError = RecipeTransferUtil.getTransferRecipeError((IRecipeTransferManager)recipeTransferManager, (AbstractContainerMenu)parentContainer, this.recipeLayout, (Player)player).orElse(null);
        } else {
            this.recipeTransferError = RecipeTransferErrorInternal.INSTANCE;
        }
        if (this.recipeTransferError == null || this.recipeTransferError.getType().allowsTransfer) {
            state.setActive(true);
            state.setVisible(true);
        } else {
            state.setActive(false);
            IRecipeTransferError.Type type = this.recipeTransferError.getType();
            state.setVisible(type == IRecipeTransferError.Type.USER_FACING);
        }
    }

    public boolean onPress(IJeiUserInput input) {
        if (!input.isSimulate()) {
            IRecipeTransferManager recipeTransferManager = Internal.getJeiRuntime().getRecipeTransferManager();
            Minecraft minecraft = Minecraft.getInstance();
            boolean maxTransfer = minecraft.hasShiftDown();
            LocalPlayer player = minecraft.player;
            AbstractContainerMenu parentContainer = this.recipesGui.getParentContainerMenu();
            if (parentContainer != null && player != null && RecipeTransferUtil.transferRecipe((IRecipeTransferManager)recipeTransferManager, (AbstractContainerMenu)parentContainer, this.recipeLayout, (Player)player, (boolean)maxTransfer)) {
                this.recipesGui.onClose();
            }
        }
        return true;
    }

    public void getTooltips(ITooltipBuilder tooltip) {
        if (this.recipeTransferError == null) {
            MutableComponent tooltipTransfer = Component.translatable((String)"jei.tooltip.transfer");
            tooltip.add((FormattedText)tooltipTransfer);
        } else {
            this.recipeTransferError.getTooltip(tooltip);
        }
    }

    public void drawExtras(GuiGraphics guiGraphics, Rect2i buttonArea, int mouseX, int mouseY, float partialTicks) {
        IRecipeTransferError recipeTransferError = this.recipeTransferError;
        if (recipeTransferError != null) {
            if (recipeTransferError.getType() == IRecipeTransferError.Type.COSMETIC) {
                guiGraphics.fill(buttonArea.getX(), buttonArea.getY(), buttonArea.getX() + buttonArea.getWidth(), buttonArea.getY() + buttonArea.getHeight(), recipeTransferError.getButtonHighlightColor());
            }
            if (buttonArea.contains(mouseX, mouseY)) {
                IRecipeSlotsView recipeSlotsView = this.recipeLayout.getRecipeSlotsView();
                Rect2i recipeRect = this.recipeLayout.getRect();
                recipeTransferError.showError(guiGraphics, mouseX, mouseY, recipeSlotsView, recipeRect.getX(), recipeRect.getY());
            }
        }
    }

    public int getMissingCountHint() {
        if (this.recipeTransferError == null) {
            return 0;
        }
        return this.recipeTransferError.getMissingCountHint();
    }
}

