/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.gui.bookmarks.BookmarkList;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.input.UserInput;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;

public class RecipeBookmarkButton
extends GuiIconToggleButton {
    private final BookmarkList bookmarks;
    @Nullable
    private final IBookmark recipeBookmark;
    private boolean bookmarked;

    public static RecipeBookmarkButton create(IRecipeLayoutDrawable<?> recipeLayout, BookmarkList bookmarks, @Nullable IBookmark recipeBookmark) {
        Textures textures = Internal.getTextures();
        IDrawableStatic icon = textures.getRecipeBookmark();
        Rect2i area = recipeLayout.getRecipeBookmarkButtonArea();
        Rect2i layoutArea = recipeLayout.getRect();
        area.setX(area.getX() + layoutArea.getX());
        area.setY(area.getY() + layoutArea.getY());
        RecipeBookmarkButton recipeBookmarkButton = new RecipeBookmarkButton((IDrawable)icon, bookmarks, recipeBookmark);
        recipeBookmarkButton.updateBounds(area);
        return recipeBookmarkButton;
    }

    private RecipeBookmarkButton(IDrawable icon, BookmarkList bookmarks, @Nullable IBookmark recipeBookmark) {
        super(icon, icon);
        this.bookmarks = bookmarks;
        this.recipeBookmark = recipeBookmark;
        if (recipeBookmark == null) {
            this.button.active = false;
            this.button.visible = false;
        }
        this.tick();
    }

    @Override
    protected void getTooltips(JeiTooltip tooltip) {
        if (this.recipeBookmark != null) {
            if (this.bookmarks.contains(this.recipeBookmark)) {
                tooltip.add((FormattedText)Component.translatable((String)"jei.tooltip.bookmarks.recipe.remove"));
            } else {
                tooltip.add((FormattedText)Component.translatable((String)"jei.tooltip.bookmarks.recipe.add"));
            }
        }
    }

    @Override
    public void tick() {
        this.bookmarked = this.recipeBookmark != null && this.bookmarks.contains(this.recipeBookmark);
    }

    @Override
    protected boolean isIconToggledOn() {
        return this.bookmarked;
    }

    @Override
    protected boolean onMouseClicked(UserInput input) {
        if (this.recipeBookmark != null) {
            if (!input.isSimulate()) {
                this.bookmarks.toggleBookmark(this.recipeBookmark);
            }
            return true;
        }
        return false;
    }

    @Override
    public void draw(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.draw(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.bookmarked) {
            guiGraphics.fill(this.button.getX(), this.button.getY(), this.button.getX() + this.button.getWidth(), this.button.getY() + this.button.getHeight(), 0x1100FF00);
        }
    }
}

