/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.ingredients;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.ingredients.TypedIngredient;
import net.minecraft.class_10302;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_3611;
import net.minecraft.class_6880;
import net.minecraft.class_9326;
import org.jetbrains.annotations.UnmodifiableView;
import org.jspecify.annotations.Nullable;

public class SimpleIngredientAcceptor
implements IIngredientAcceptor<SimpleIngredientAcceptor> {
    private final IIngredientManager ingredientManager;
    private final List<ITypedIngredient<?>> ingredients = new ArrayList();

    public SimpleIngredientAcceptor(IIngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
    }

    @Override
    public SimpleIngredientAcceptor addIngredientsUnsafe(List<?> ingredients) {
        Preconditions.checkNotNull(ingredients, (Object)"ingredients");
        for (Object ingredient : ingredients) {
            ITypedIngredient<?> typedIngredient = TypedIngredient.createAndFilterInvalid(this.ingredientManager, ingredient, false);
            if (typedIngredient == null) continue;
            this.ingredients.add(typedIngredient);
        }
        return this;
    }

    @Override
    public <T> SimpleIngredientAcceptor addIngredients(IIngredientType<T> ingredientType, List<@Nullable T> ingredients) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        Preconditions.checkNotNull(ingredients, (Object)"ingredients");
        List<@Nullable ITypedIngredient<T>> typedIngredients = TypedIngredient.createAndFilterInvalidList(this.ingredientManager, ingredientType, ingredients, false);
        for (ITypedIngredient<T> typedIngredientOptional : typedIngredients) {
            if (typedIngredientOptional == null) continue;
            this.ingredients.add(typedIngredientOptional);
        }
        return this;
    }

    @Override
    public SimpleIngredientAcceptor add(class_10302 slotDisplay) {
        ErrorUtil.checkNotNull(slotDisplay, "slotDisplay");
        List<@Nullable ITypedIngredient<class_1799>> typedIngredients = TypedIngredient.createAndFilterInvalidList(this.ingredientManager, slotDisplay, false);
        for (ITypedIngredient<class_1799> typedIngredient : typedIngredients) {
            if (typedIngredient == null) continue;
            this.add(typedIngredient);
        }
        return this;
    }

    @Override
    public <T> SimpleIngredientAcceptor add(IIngredientType<T> ingredientType, T ingredient) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        this.addIngredientInternal(ingredientType, ingredient);
        return this;
    }

    @Override
    public <I> SimpleIngredientAcceptor add(ITypedIngredient<I> typedIngredient) {
        ErrorUtil.checkNotNull(typedIngredient, "typedIngredient");
        ITypedIngredient<I> copy = TypedIngredient.defensivelyCopyTypedIngredientFromApi(this.ingredientManager, typedIngredient);
        if (copy != null) {
            this.ingredients.add(copy);
        }
        return this;
    }

    @Override
    public SimpleIngredientAcceptor add(class_3611 fluid) {
        IPlatformFluidHelperInternal<?> fluidHelper = Services.PLATFORM.getFluidHelper();
        return this.addFluidInternal(fluidHelper, (class_6880<class_3611>)fluid.method_40178(), fluidHelper.bucketVolume(), class_9326.field_49588);
    }

    @Override
    public SimpleIngredientAcceptor add(class_3611 fluid, long amount) {
        IPlatformFluidHelperInternal<?> fluidHelper = Services.PLATFORM.getFluidHelper();
        return this.addFluidInternal(fluidHelper, (class_6880<class_3611>)fluid.method_40178(), amount, class_9326.field_49588);
    }

    @Override
    public SimpleIngredientAcceptor add(class_3611 fluid, long amount, class_9326 component) {
        IPlatformFluidHelperInternal<?> fluidHelper = Services.PLATFORM.getFluidHelper();
        return this.addFluidInternal(fluidHelper, (class_6880<class_3611>)fluid.method_40178(), amount, component);
    }

    @Override
    public SimpleIngredientAcceptor add(class_1856 ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        List<@Nullable ITypedIngredient<class_1799>> typedIngredients = TypedIngredient.createAndFilterInvalidList(this.ingredientManager, ingredient, false);
        for (ITypedIngredient<class_1799> typedIngredientOptional : typedIngredients) {
            if (typedIngredientOptional == null) continue;
            this.ingredients.add(typedIngredientOptional);
        }
        return this;
    }

    private <T> SimpleIngredientAcceptor addFluidInternal(IPlatformFluidHelperInternal<T> fluidHelper, class_6880<class_3611> fluidHolder, long amount, class_9326 component) {
        Object fluidStack = fluidHelper.create(fluidHolder, amount, component);
        IIngredientTypeWithSubtypes fluidIngredientType = fluidHelper.getFluidIngredientType();
        this.addIngredientInternal(fluidIngredientType, fluidStack);
        return this;
    }

    @Override
    public SimpleIngredientAcceptor addTypedIngredients(List<ITypedIngredient<?>> ingredients) {
        ErrorUtil.checkNotNull(ingredients, "ingredients");
        for (ITypedIngredient<?> typedIngredient : ingredients) {
            this.add(typedIngredient);
        }
        return this;
    }

    @Override
    public SimpleIngredientAcceptor addOptionalTypedIngredients(List<Optional<ITypedIngredient<?>>> ingredients) {
        ErrorUtil.checkNotNull(ingredients, "ingredients");
        for (Optional<ITypedIngredient<?>> optionalTypedIngredient : ingredients) {
            if (!optionalTypedIngredient.isPresent()) continue;
            this.ingredients.add(optionalTypedIngredient.get());
        }
        return this;
    }

    private <T> void addIngredientInternal(IIngredientType<T> ingredientType, @Nullable T ingredient) {
        if (ingredient == null) {
            return;
        }
        ITypedIngredient<T> typedIngredient = TypedIngredient.createAndFilterInvalid(this.ingredientManager, ingredientType, ingredient, false);
        if (typedIngredient != null) {
            this.ingredients.add(typedIngredient);
        }
    }

    public @UnmodifiableView List<ITypedIngredient<?>> getAllIngredients() {
        return Collections.unmodifiableList(this.ingredients);
    }
}

