package mezz.jei.library.plugins.vanilla.crafting;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mezz.jei.library.recipes.RecipeSerializers;
import net.minecraft.class_10295;
import net.minecraft.class_10300;
import net.minecraft.class_10302;
import net.minecraft.class_10352;
import net.minecraft.class_10363;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3955;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_8957;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9694;
import net.minecraft.class_9887;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class JeiShapedRecipe implements class_3955 {
	private final class_8957 pattern;
	private final List<class_10302> displays;
	private final class_10302 results;
	private final String group;
	private final class_7710 category;

	public JeiShapedRecipe(String group, class_7710 category, class_8957 pattern, List<class_10302> displays, class_10302 results) {
		this.group = group;
		this.category = category;
		this.pattern = pattern;
		this.displays = displays;
		this.results = results;
	}

	@Override
	public class_1865<? extends class_3955> method_8119() {
		return RecipeSerializers.getJeiShapedRecipeSerializer();
	}

	@Override
	public class_9887 method_61671() {
		return class_9887.method_61683(pattern.method_59997());
	}

	@Override
	public String method_8112() {
		return group;
	}

	@Override
	public class_7710 method_45441() {
		return this.category;
	}

	@Override
	public List<class_10295> method_64664() {
		return List.of(
			new class_10300(
				this.pattern.method_59995(),
				this.pattern.method_59996(),
				displays,
				results,
				new class_10302.class_10306(class_1802.field_8465)
			)
		);
	}

	@Override
	public boolean method_49188() {
		return false;
	}

	@Override
	public boolean matches(class_9694 input, class_1937 level) {
		return this.pattern.method_55078(input);
	}

	@Override
	public class_1799 assemble(class_9694 input, class_7225.class_7874 registries) {
		class_310 minecraft = class_310.method_1551();
		class_10352 contextmap = class_10363.method_65008(Objects.requireNonNull(minecraft.field_1687));
		return this.results.method_64742(contextmap).method_7972();
	}

	public int getWidth() {
		return this.pattern.method_59995();
	}

	public int getHeight() {
		return this.pattern.method_59996();
	}

	public static class Serializer implements class_1865<JeiShapedRecipe> {
		public static final MapCodec<JeiShapedRecipe> CODEC = RecordCodecBuilder.mapCodec((instance) -> {
			return instance.group(Codec.STRING.optionalFieldOf("group", "").forGetter((shapedRecipe) -> {
				return shapedRecipe.group;
			}), class_7710.field_40252.fieldOf("category").orElse(class_7710.field_40251).forGetter((shapedRecipe) -> {
				return shapedRecipe.category;
			}), class_8957.field_47321.forGetter((shapedRecipe) -> {
				return shapedRecipe.pattern;
			}), Codec.list(class_10302.field_54671).fieldOf("display").forGetter((shapedRecipe) -> {
				return shapedRecipe.displays;
			}), class_10302.field_54671.fieldOf("result").forGetter((shapedRecipe) -> {
				return shapedRecipe.results;
			})).apply(instance, JeiShapedRecipe::new);
		});
		public static final class_9139<class_9129, JeiShapedRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

		public Serializer() {
		}

		@Override
		public MapCodec<JeiShapedRecipe> method_53736() {
			return CODEC;
		}

		@Override
		@Deprecated
		public class_9139<class_9129, JeiShapedRecipe> method_56104() {
			return STREAM_CODEC;
		}

		private static JeiShapedRecipe fromNetwork(class_9129 buffer) {
			String string = buffer.method_19772();
			class_7710 craftingBookCategory = buffer.method_10818(class_7710.class);
			class_8957 shapedRecipePattern = class_8957.field_48359.decode(buffer);

			int displayCount = buffer.method_10816();
			if (displayCount < 9) {
				throw new IllegalArgumentException("Display count must be 9 or fewer");
			}
			List<class_10302> displays = new ArrayList<>(displayCount);
			for (int i = 0; i < displayCount; i++) {
				class_10302 display = class_10302.field_54672.decode(buffer);
				displays.add(display);
			}

			class_10302 results = class_10302.field_54672.decode(buffer);
			return new JeiShapedRecipe(string, craftingBookCategory, shapedRecipePattern, displays, results);
		}

		private static void toNetwork(class_9129 buffer, JeiShapedRecipe recipe) {
			buffer.method_10814(recipe.group);
			buffer.method_10817(recipe.category);
			class_8957.field_48359.encode(buffer, recipe.pattern);

			List<class_10302> displays = recipe.displays;
			buffer.method_10804(displays.size());
			for (class_10302 display : displays) {
				class_10302.field_54672.encode(buffer, display);
			}

			class_10302.field_54672.encode(buffer, recipe.results);
		}
	}
}
