package mezz.jei.library.gui.recipes;

import mezz.jei.api.gui.inputs.IJeiGuiEventListener;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.common.util.MathUtil;
import net.minecraft.class_3675;
import net.minecraft.class_768;
import net.minecraft.class_8029;
import net.minecraft.class_8030;
import java.util.ArrayList;
import java.util.List;

public class RecipeLayoutInputHandler<T> implements IJeiInputHandler {
	private final RecipeLayout<T> recipeLayout;
	private final List<IJeiInputHandler> inputHandlers;
	private final List<IJeiGuiEventListener> guiEventListeners;

	public RecipeLayoutInputHandler(
		RecipeLayout<T> recipeLayout
	) {
		this.recipeLayout = recipeLayout;
		this.inputHandlers = new ArrayList<>();
		this.guiEventListeners = new ArrayList<>();
	}

	@Override
	public class_8030 getArea() {
		class_768 area = recipeLayout.getRect();
		return new class_8030(area.method_3321(), area.method_3322(), area.method_3319(), area.method_3320());
	}

	@Override
	public boolean handleInput(double mouseX, double mouseY, IJeiUserInput userInput) {
		if (!recipeLayout.isMouseOver(mouseX, mouseY)) {
			return false;
		}

		class_768 area = recipeLayout.getRect();
		final double recipeMouseX = mouseX - area.method_3321();
		final double recipeMouseY = mouseY - area.method_3322();

		for (IJeiInputHandler inputHandler : inputHandlers) {
			class_8030 widgetArea = inputHandler.getArea();
			if (MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY)) {
				class_8029 position = widgetArea.comp_1195();
				double relativeMouseX = recipeMouseX - position.comp_1193();
				double relativeMouseY = recipeMouseY - position.comp_1194();
				if (inputHandler.handleInput(relativeMouseX, relativeMouseY, userInput)) {
					return true;
				}
			}
		}
		for (IJeiGuiEventListener guiEventListener : guiEventListeners) {
			class_8030 widgetArea = guiEventListener.getArea();
			if (MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY)) {
				class_8029 position = widgetArea.comp_1195();
				double relativeMouseX = recipeMouseX - position.comp_1193();
				double relativeMouseY = recipeMouseY - position.comp_1194();
				if (handleInput(guiEventListener, relativeMouseX, relativeMouseY, userInput)) {
					return true;
				}
			}
		}

		return false;
	}

	private static boolean handleInput(IJeiGuiEventListener guiEventListener, double relativeMouseX, double relativeMouseY, IJeiUserInput userInput) {
		class_3675.class_306 key = userInput.getKey();
		switch (key.method_1442()) {
			case field_1672 -> {
				if (userInput.isSimulate()) {
					return guiEventListener.mouseClicked(relativeMouseX, relativeMouseY, key.method_1444());
				} else {
					return guiEventListener.mouseReleased(relativeMouseX, relativeMouseY, key.method_1444());
				}
			}
			case field_1668 -> {
				if (!userInput.isSimulate()) {
					return guiEventListener.keyPressed(relativeMouseX, relativeMouseY, key.method_1444(), 0, userInput.getModifiers());
				}
			}
			default -> {
				return false;
			}
		}
		return false;
	}

	@Override
	public boolean handleMouseDragged(double mouseX, double mouseY, class_3675.class_306 mouseKey, double dragX, double dragY) {
		if (!recipeLayout.isMouseOver(mouseX, mouseY)) {
			return false;
		}

		class_768 area = recipeLayout.getRect();
		final double recipeMouseX = mouseX - area.method_3321();
		final double recipeMouseY = mouseY - area.method_3322();

		for (IJeiInputHandler inputHandler : inputHandlers) {
			class_8030 widgetArea = inputHandler.getArea();
			if (MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY)) {
				class_8029 position = widgetArea.comp_1195();
				double relativeMouseX = recipeMouseX - position.comp_1193();
				double relativeMouseY = recipeMouseY - position.comp_1194();
				if (inputHandler.handleMouseDragged(relativeMouseX, relativeMouseY, mouseKey, dragX, dragY)) {
					return true;
				}
			}
		}
		for (IJeiGuiEventListener guiEventListener : guiEventListeners) {
			class_8030 widgetArea = guiEventListener.getArea();
			if (MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY)) {
				class_8029 position = widgetArea.comp_1195();
				double relativeMouseX = recipeMouseX - position.comp_1193();
				double relativeMouseY = recipeMouseY - position.comp_1194();
				if (guiEventListener.mouseDragged(relativeMouseX, relativeMouseY, mouseKey.method_1444(), dragX, dragY)) {
					return true;
				}
			}
		}
		return false;
	}

	@Override
	public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
		if (!recipeLayout.isMouseOver(mouseX, mouseY)) {
			return false;
		}

		class_768 area = recipeLayout.getRect();
		final double recipeMouseX = mouseX - area.method_3321();
		final double recipeMouseY = mouseY - area.method_3322();

		for (IJeiInputHandler inputHandler : inputHandlers) {
			class_8030 widgetArea = inputHandler.getArea();
			if (MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY)) {
				class_8029 position = widgetArea.comp_1195();
				double relativeMouseX = recipeMouseX - position.comp_1193();
				double relativeMouseY = recipeMouseY - position.comp_1194();
				if (inputHandler.handleMouseScrolled(relativeMouseX, relativeMouseY, scrollDeltaX, scrollDeltaY)) {
					return true;
				}
			}
		}
		for (IJeiGuiEventListener guiEventListener : guiEventListeners) {
			class_8030 widgetArea = guiEventListener.getArea();
			if (MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY)) {
				class_8029 position = widgetArea.comp_1195();
				double relativeMouseX = recipeMouseX - position.comp_1193();
				double relativeMouseY = recipeMouseY - position.comp_1194();
				if (guiEventListener.mouseScrolled(relativeMouseX, relativeMouseY, scrollDeltaX, scrollDeltaY)) {
					return true;
				}
			}
		}
		return false;
	}

	@Override
	public void handleMouseMoved(double mouseX, double mouseY) {
		if (!recipeLayout.isMouseOver(mouseX, mouseY)) {
			return;
		}

		class_768 area = recipeLayout.getRect();
		final double recipeMouseX = mouseX - area.method_3321();
		final double recipeMouseY = mouseY - area.method_3322();

		for (IJeiInputHandler inputHandler : inputHandlers) {
			class_8030 widgetArea = inputHandler.getArea();
			if (MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY)) {
				class_8029 position = widgetArea.comp_1195();
				double relativeMouseX = recipeMouseX - position.comp_1193();
				double relativeMouseY = recipeMouseY - position.comp_1194();
				inputHandler.handleMouseMoved(relativeMouseX, relativeMouseY);
			}
		}
		for (IJeiGuiEventListener guiEventListener : guiEventListeners) {
			class_8030 widgetArea = guiEventListener.getArea();
			if (MathUtil.contains(widgetArea, recipeMouseX, recipeMouseY)) {
				class_8029 position = widgetArea.comp_1195();
				double relativeMouseX = recipeMouseX - position.comp_1193();
				double relativeMouseY = recipeMouseY - position.comp_1194();
				guiEventListener.mouseMoved(relativeMouseX, relativeMouseY);
			}
		}
	}

	public void addInputHandler(IJeiInputHandler inputHandler) {
		this.inputHandlers.add(inputHandler);
	}

	public void addGuiEventListener(IJeiGuiEventListener guiEventListener) {
		this.guiEventListeners.add(guiEventListener);
	}
}
