package mezz.jei.gui.elements;

import mezz.jei.api.gui.buttons.IButtonState;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.common.gui.elements.DrawableBlank;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.class_11910;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_9848;

/**
 * A button that has an {@link IDrawable} instead of a string label.
 * This internal class is used for re-using vanilla render code and to override behavior.
 * See {@link IconButton} for the class that uses this.
 */
class InternalIconButton extends class_4185 implements IButtonState {
	private static final ButtonSprites SPRITES = new ButtonSprites();

	private IDrawable icon = DrawableBlank.EMPTY;
	private boolean pressed = false;
	private boolean forcePressed = false;

	public InternalIconButton() {
		super(0, 0, 0, 0, class_5244.field_39003, b -> {}, class_4185.field_40754);
	}

	public void updateBounds(ImmutableRect2i area) {
		method_46421(area.getX());
		method_46419(area.getY());
		this.field_22758 = area.getWidth();
		this.field_22759 = area.getHeight();
	}

	@Override
	public void method_53533(int value) {
		this.field_22759 = value;
	}

	@Override
	protected void method_75752(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
		SPRITES.render(
			guiGraphics,
			this.field_22763,
			this.method_25367(),
			this.pressed || this.forcePressed,
			this.method_46426(),
			this.method_46427(),
			this.method_25368(),
			this.method_25364(),
			class_9848.method_61317(this.field_22765)
		);

		float xOffset = method_46426() + (field_22758 - icon.getWidth()) / 2.0f;
		float yOffset = method_46427() + (field_22759 - icon.getHeight()) / 2.0f;
		if (this.pressed || this.forcePressed) {
			xOffset += 0.5f;
			yOffset += 0.5f;
		}
		var poseStack = guiGraphics.method_51448();
		poseStack.pushMatrix();
		{
			poseStack.translate(xOffset, yOffset);
			icon.draw(guiGraphics);
		}
		poseStack.popMatrix();
	}

	public void setPressed(boolean pressed) {
		this.pressed = pressed;
	}

	@Override
	public void setForcePressed(boolean forcePressed) {
		this.forcePressed = forcePressed;
	}

	@Override
	public boolean method_25351(class_11910 p_447020_) {
		return super.method_25351(p_447020_);
	}

	@Override
	public void setIcon(IDrawable icon) {
		this.icon = icon;
	}

	@Override
	public void setActive(boolean value) {
		this.field_22763 = value;
	}

	@Override
	public void setVisible(boolean value) {
		this.field_22764 = value;
	}
}
